/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.patchouli.component;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.registry.ImbuementRecipeRegistry;
import com.hollingsworth.arsnouveau.client.patchouli.component.RotatingItemListComponentBase;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import vazkii.patchouli.api.IVariable;

public class RotatingItemListComponent
extends RotatingItemListComponentBase {
    @SerializedName(value="recipe_name")
    public String recipeName;
    @SerializedName(value="recipe_type")
    public String recipeType;

    @Override
    protected List<Ingredient> makeIngredients() {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return new ArrayList<Ingredient>();
        }
        if ("enchanting_apparatus".equals(this.recipeType)) {
            RecipeHolder holder = world.getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.APPARATUS_TYPE.get()).stream().filter(f -> f.id().toString().equals(this.recipeName)).findFirst().orElse(null);
            EnchantingApparatusRecipe recipe = holder != null ? (EnchantingApparatusRecipe)holder.value() : null;
            for (RecipeType<? extends IEnchantingRecipe> type : ArsNouveauAPI.getInstance().getEnchantingRecipeTypes()) {
                EnchantingApparatusRecipe enchantingApparatusRecipe;
                Recipe recipe2;
                RecipeHolder recipe1 = world.getRecipeManager().getAllRecipesFor(type).stream().filter(f -> f.id().toString().equals(this.recipeName)).findFirst().orElse(null);
                if (recipe1 == null || !((recipe2 = recipe1.value()) instanceof EnchantingApparatusRecipe)) continue;
                recipe = enchantingApparatusRecipe = (EnchantingApparatusRecipe)recipe2;
                break;
            }
            return recipe == null ? ImmutableList.of() : recipe.pedestalItems();
        }
        if ("imbuement_chamber".equals(this.recipeType)) {
            RecipeHolder holder = world.getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.IMBUEMENT_TYPE.get()).stream().filter(f -> f.id().toString().equals(this.recipeName)).findFirst().orElse(null);
            ImbuementRecipe recipe = holder != null ? (ImbuementRecipe)holder.value() : null;
            Iterator iterator = ImbuementRecipeRegistry.INSTANCE.getRecipeTypes().iterator();
            while (iterator.hasNext()) {
                ImbuementRecipe imbuementRecipe;
                Recipe recipe3;
                RecipeType type;
                RecipeType imbuementRecipeType = type = iterator.next();
                RecipeHolder recipe1 = world.getRecipeManager().getAllRecipesFor(imbuementRecipeType).stream().filter(f -> f.id().toString().equals(this.recipeName)).findFirst().orElse(null);
                if (recipe1 == null || !((recipe3 = recipe1.value()) instanceof ImbuementRecipe)) continue;
                recipe = imbuementRecipe = (ImbuementRecipe)recipe3;
                break;
            }
            return recipe == null ? ImmutableList.of() : recipe.pedestalItems;
        }
        if ("glyph_recipe".equals(this.recipeType)) {
            RecipeHolder recipe = world.getRecipeManager().byKey(ResourceLocation.tryParse((String)this.recipeName)).orElse(null);
            return recipe == null ? ImmutableList.of() : ((GlyphRecipe)recipe.value()).inputs;
        }
        throw new IllegalArgumentException("Type must be 'enchanting_apparatus', 'glyph_recipe', or 'imbuement_chamber'!");
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registries) {
        this.recipeName = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeName))).asString();
        this.recipeType = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeType))).asString();
    }
}

