/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.patchouli;

import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ImbuementProcessor
implements IComponentProcessor {
    RecipeHolder<? extends ImbuementRecipe> holder;

    public void setup(Level level, IVariableProvider variables) {
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        String recipeID = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        this.holder = manager.byKey(ResourceLocation.tryParse((String)recipeID)).orElse(null);
    }

    public IVariable process(Level level, String key) {
        if (this.holder == null) {
            return null;
        }
        ImbuementRecipe recipe = (ImbuementRecipe)this.holder.value();
        if (key.equals("reagent")) {
            return IVariable.wrapList((Iterable)Arrays.stream(recipe.input.getItems()).map(i -> IVariable.from((Object)i, (HolderLookup.Provider)level.registryAccess())).collect(Collectors.toList()), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("output")) {
            return IVariable.from((Object)recipe.output, (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("footer")) {
            return IVariable.wrap((String)recipe.output.getItem().getDescriptionId(), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

