/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;

public class CraftingButton
extends GuiImageButton {
    protected AbstractSpellPart abstractSpellPart = null;
    protected AbstractSpellPart augmentedParent = null;
    public List<SpellValidationError> validationErrors = new LinkedList<SpellValidationError>();
    public int slotNum;

    public CraftingButton(int x, int y, Button.OnPress onPress, int slotNum) {
        super(x, y, 0, 0, 22, 20, 22, 20, "textures/gui/spell_glyph_slot.png", onPress);
        this.slotNum = slotNum;
    }

    public void clear() {
        this.validationErrors.clear();
        this.abstractSpellPart = null;
        this.augmentedParent = null;
    }

    @Nullable
    public AbstractSpellPart getAbstractSpellPart() {
        return this.abstractSpellPart;
    }

    public void setAbstractSpellPart(AbstractSpellPart abstractSpellPart) {
        this.abstractSpellPart = abstractSpellPart;
    }

    public void setAugmenting(@Nullable AbstractSpellPart parent) {
        this.augmentedParent = parent;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.validationErrors.isEmpty()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)0.7f, (float)0.7f, (float)1.0f);
        }
        if (this.abstractSpellPart != null) {
            RenderUtils.drawSpellPart(this.abstractSpellPart, graphics, this.x + 3, this.y + 2, 16, !this.validationErrors.isEmpty(), 0);
        }
        super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    public void getTooltip(List<Component> tip) {
        if (this.abstractSpellPart != null) {
            tip.add((Component)Component.translatable((String)this.abstractSpellPart.getLocalizationKey()));
            for (SpellValidationError spellValidationError : this.validationErrors) {
                tip.add((Component)spellValidationError.makeTextComponentExisting().withStyle(ChatFormatting.RED));
            }
            AbstractSpellPart abstractSpellPart = this.abstractSpellPart;
            if (abstractSpellPart instanceof AbstractAugment) {
                AbstractAugment augment = (AbstractAugment)abstractSpellPart;
                if (this.augmentedParent != null) {
                    if (this.validationErrors != null && !this.validationErrors.isEmpty()) {
                        return;
                    }
                    Component component = this.augmentedParent.augmentDescriptions.get(augment);
                    if (component != null) {
                        tip.add((Component)Component.translatable((String)"ars_nouveau.augmenting", (Object[])new Object[]{this.augmentedParent.getLocaleName()}));
                        tip.add((Component)component.copy().withStyle(ChatFormatting.GOLD));
                    }
                }
            }
            if (Screen.hasShiftDown()) {
                tip.add((Component)Component.translatable((String)"tooltip.ars_nouveau.glyph_level", (Object[])new Object[]{this.abstractSpellPart.getConfigTier().value}).setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
                tip.add((Component)Component.translatable((String)"ars_nouveau.schools"));
                for (SpellSchool spellSchool : this.abstractSpellPart.spellSchools) {
                    tip.add(spellSchool.getTextComponent());
                }
                tip.add(this.abstractSpellPart.getBookDescLang());
            } else {
                tip.add((Component)Component.translatable((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getKey().getDisplayName()}));
                String modName = ModList.get().getModContainerById(this.abstractSpellPart.getRegistryName().getNamespace()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(this.abstractSpellPart.getRegistryName().getNamespace());
                tip.add((Component)Component.literal((String)modName).withStyle(ChatFormatting.BLUE));
            }
        }
    }
}

