/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.loot;

import com.hollingsworth.arsnouveau.api.loot.DungeonLootTables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;

public class DungeonLootEnhancerModifier
extends LootModifier {
    public double commonChance;
    public double uncommonChance;
    public double rareChance;
    public int commonRolls;
    public int uncommonRolls;
    public int rareRolls;
    public static final MapCodec<DungeonLootEnhancerModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> DungeonLootEnhancerModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.DOUBLE.optionalFieldOf("common_chance", (Object)0.3).forGetter(d -> d.commonChance), (App)Codec.DOUBLE.optionalFieldOf("uncommon_chance", (Object)0.2).forGetter(d -> d.uncommonChance), (App)Codec.DOUBLE.optionalFieldOf("rare_chance", (Object)0.1).forGetter(d -> d.rareChance), (App)Codec.INT.optionalFieldOf("common_rolls", (Object)3).forGetter(d -> d.commonRolls), (App)Codec.INT.optionalFieldOf("uncommon_rolls", (Object)2).forGetter(d -> d.uncommonRolls), (App)Codec.INT.optionalFieldOf("rare_rolls", (Object)1).forGetter(d -> d.rareRolls))).apply((Applicative)instance, DungeonLootEnhancerModifier::new));

    public DungeonLootEnhancerModifier(LootItemCondition[] conditionsIn, double commonChance, double uncommonChance, double rareChance, int commonRolls, int uncommonRolls, int rareRolls) {
        super(conditionsIn);
        this.commonChance = commonChance;
        this.uncommonChance = uncommonChance;
        this.rareChance = rareChance;
        this.commonRolls = commonRolls;
        this.uncommonRolls = uncommonRolls;
        this.rareRolls = rareRolls;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        generatedLoot.addAll(DungeonLootTables.getRandomRoll(this));
        return generatedLoot;
    }

    public MapCodec<DungeonLootEnhancerModifier> codec() {
        return CODEC;
    }
}

