/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageWidget;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.nuggets.client.gui.NuggetMultilLineLabel;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TextEntry
extends SinglePageWidget {
    public NuggetMultilLineLabel body;
    @Nullable
    public Component title;
    @Nullable
    public ItemStack renderStack;
    public NuggetMultilLineLabel titleLabel;
    public static int TITLE_WIDTH = 94;

    public TextEntry(Component body, Component title, ItemStack renderStack, BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.body = NuggetMultilLineLabel.create((Font)Minecraft.getInstance().font, (Component)body.copy().withStyle(Style.EMPTY.withFont(Minecraft.UNIFORM_FONT)), (int)width);
        this.title = title;
        this.renderStack = renderStack;
        if (title != null) {
            this.titleLabel = NuggetMultilLineLabel.create((Font)Minecraft.getInstance().font, (Component)title, (int)TITLE_WIDTH);
        }
    }

    public TextEntry(NuggetMultilLineLabel body, Component title, ItemStack renderStack, BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.body = body;
        this.title = title;
        this.renderStack = renderStack;
        if (title != null) {
            this.titleLabel = NuggetMultilLineLabel.create((Font)Minecraft.getInstance().font, (Component)title, (int)TITLE_WIDTH);
        }
    }

    public static SinglePageCtor create(Component body, Component title, ItemStack renderStack) {
        return (parent, x, y, width, height) -> new TextEntry(body, title, renderStack, parent, x, y, width, height);
    }

    public static SinglePageCtor create(Component body, Component title, ItemLike renderStack) {
        return (parent, x, y, width, height) -> new TextEntry(body, title, renderStack.asItem().getDefaultInstance(), parent, x, y, width, height);
    }

    public static SinglePageCtor create(NuggetMultilLineLabel body, Component title, ItemStack renderStack) {
        return (parent, x, y, width, height) -> new TextEntry(body, title, renderStack, parent, x, y, width, height);
    }

    public static SinglePageCtor create(NuggetMultilLineLabel body, Component title) {
        return (parent, x, y, width, height) -> new TextEntry(body, title, null, parent, x, y, width, height);
    }

    public static SinglePageCtor create(Component body, Component title) {
        return (parent, x, y, width, height) -> new TextEntry(body, title, null, parent, x, y, width, height);
    }

    public static SinglePageCtor create(Component body) {
        return (parent, x, y, width, height) -> new TextEntry(body, null, null, parent, x, y, width, height);
    }

    public static SinglePageCtor create(NuggetMultilLineLabel body) {
        return (parent, x, y, width, height) -> new TextEntry(body, null, null, parent, x, y, width, height);
    }

    public static SinglePageCtor create(String body) {
        return (parent, x, y, width, height) -> new TextEntry((Component)Component.translatable((String)body), null, null, parent, x, y, width, height);
    }

    public static SinglePageCtor create(String body, String title) {
        return (parent, x, y, width, height) -> new TextEntry((Component)Component.translatable((String)body), (Component)Component.translatable((String)title), null, parent, x, y, width, height);
    }

    public int drawTitle(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.renderStack != null) {
            DocClientUtils.blit(guiGraphics, DocAssets.HEADER_WITH_ITEM, this.x, this.y - 1);
            this.setTooltipIfHovered(DocClientUtils.renderItemStack(guiGraphics, this.x + 3, this.y + 2, mouseX, mouseY, this.renderStack));
            DocClientUtils.drawHeader(this.titleLabel, guiGraphics, this.x + 70, this.y - 1);
            return 24;
        }
        DocClientUtils.drawHeader(this.title, guiGraphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
        return 20;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        boolean hasTitle = this.title != null;
        int yOffset = -3;
        if (hasTitle) {
            yOffset = this.drawTitle(guiGraphics, mouseX, mouseY, partialTick);
        }
        DocClientUtils.drawParagraph(this.body, guiGraphics, this.x, this.y + yOffset, this.width, mouseX, mouseY, partialTick);
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public void addExportProperties(JsonObject object) {
        if (this.title != null) {
            object.addProperty(DocExporter.TITLE_PROPERTY, this.title.getString());
        }
        object.addProperty(DocExporter.DESCRIPTION_PROPERTY, this.body.getString());
        if (this.renderStack != null && !this.renderStack.isEmpty()) {
            object.addProperty(DocExporter.ICON_PROPERTY, BuiltInRegistries.ITEM.getKey((Object)this.renderStack.getItem()).toString());
        }
    }
}

