/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.loottable;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockEntity;
import de.melanx.extradisks.loottable.ExtraLootFunctions;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ExtraStorageBlockLootFunction
extends LootItemConditionalFunction {
    public ExtraStorageBlockLootFunction() {
        super(List.of());
    }

    @Nonnull
    protected ItemStack run(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity transferable = (StorageBlockEntity)blockEntity;
            RefinedStorageApi.INSTANCE.getStorageContainerItemHelper().transferFromBlockEntity(stack, transferable);
        }
        return stack;
    }

    @Nonnull
    public LootItemFunctionType<ExtraStorageBlockLootFunction> getType() {
        return ExtraLootFunctions.STORAGE_BLOCK;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        @Nonnull
        protected Builder getThis() {
            return this;
        }

        @Nonnull
        public LootItemFunction build() {
            return new ExtraStorageBlockLootFunction();
        }
    }
}

