/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.setup;

import dev.su5ed.mffs.block.ForceFieldBlockImpl;
import dev.su5ed.mffs.render.BiometricIdentifierRenderer;
import dev.su5ed.mffs.render.CoercionDeriverRenderer;
import dev.su5ed.mffs.render.ForceFieldBlockEntityRenderer;
import dev.su5ed.mffs.render.LazyRendererFactory;
import dev.su5ed.mffs.render.ProjectorModeRenderer;
import dev.su5ed.mffs.render.ProjectorRenderer;
import dev.su5ed.mffs.render.RenderPostProcessor;
import dev.su5ed.mffs.render.model.CoercionDeriverTopModel;
import dev.su5ed.mffs.render.model.ForceCubeModel;
import dev.su5ed.mffs.render.model.ForceFieldBlockModelLoader;
import dev.su5ed.mffs.render.model.ForceTubeModel;
import dev.su5ed.mffs.render.model.ProjectorRotorModel;
import dev.su5ed.mffs.render.particle.BeamParticleProvider;
import dev.su5ed.mffs.render.particle.MovingHologramParticleProvider;
import dev.su5ed.mffs.screen.BiometricIdentifierScreen;
import dev.su5ed.mffs.screen.CoercionDeriverScreen;
import dev.su5ed.mffs.screen.FortronCapacitorScreen;
import dev.su5ed.mffs.screen.InterdictionMatrixScreen;
import dev.su5ed.mffs.screen.ProjectorScreen;
import dev.su5ed.mffs.setup.ModBlocks;
import dev.su5ed.mffs.setup.ModItems;
import dev.su5ed.mffs.setup.ModMenus;
import dev.su5ed.mffs.setup.ModObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

@EventBusSubscriber(modid="mffs", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public final class ModClientSetup {
    private static final Map<Item, LazyRendererFactory> LAZY_RENDERERS = new HashMap<Item, LazyRendererFactory>();

    public static void renderLazy(Item item, BlockEntity be, Function<ModelLayerLocation, ModelPart> modelFactory) {
        LazyRendererFactory factory = LAZY_RENDERERS.get(item);
        if (factory != null) {
            factory.apply(be, modelFactory);
        }
    }

    public static boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    private static void registerLazyRenderers() {
        LAZY_RENDERERS.put((Item)ModItems.CUBE_MODE.get(), ProjectorModeRenderer::renderCubeMode);
        LAZY_RENDERERS.put((Item)ModItems.SPHERE_MODE.get(), ProjectorModeRenderer::renderSphereMode);
        LAZY_RENDERERS.put((Item)ModItems.TUBE_MODE.get(), ProjectorModeRenderer::renderTubeMode);
        LAZY_RENDERERS.put((Item)ModItems.PYRAMID_MODE.get(), ProjectorModeRenderer::renderPyramidMode);
        LAZY_RENDERERS.put((Item)ModItems.CYLINDER_MODE.get(), ProjectorModeRenderer::renderCylinderMode);
        LAZY_RENDERERS.put((Item)ModItems.CUSTOM_MODE.get(), ProjectorModeRenderer::renderCustomMode);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ModClientSetup.registerLazyRenderers();
            RenderPostProcessor.initRenderTarget();
        });
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenus.COERCION_DERIVER_MENU.get(), CoercionDeriverScreen::new);
        event.register((MenuType)ModMenus.FORTRON_CAPACITOR_MENU.get(), FortronCapacitorScreen::new);
        event.register((MenuType)ModMenus.PROJECTOR_MENU.get(), ProjectorScreen::new);
        event.register((MenuType)ModMenus.BIOMETRIC_IDENTIFIER_MENU.get(), BiometricIdentifierScreen::new);
        event.register((MenuType)ModMenus.INTERDICTION_MATRIX_MENU.get(), InterdictionMatrixScreen::new);
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModObjects.PROJECTOR_BLOCK_ENTITY.get(), ProjectorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModObjects.COERCION_DERIVER_BLOCK_ENTITY.get(), CoercionDeriverRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModObjects.BIOMETRIC_IDENTIFIER_BLOCK_ENTITY.get(), BiometricIdentifierRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModObjects.FORCE_FIELD_BLOCK_ENTITY.get(), ForceFieldBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticleFactory(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)ModObjects.BEAM_PARTICLE.get(), (ParticleProvider)new BeamParticleProvider());
        event.registerSpecial((ParticleType)ModObjects.MOVING_HOLOGRAM_PARTICLE.get(), (ParticleProvider)new MovingHologramParticleProvider());
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ProjectorRotorModel.LAYER_LOCATION, ProjectorRotorModel::createBodyLayer);
        event.registerLayerDefinition(CoercionDeriverTopModel.LAYER_LOCATION, CoercionDeriverTopModel::createBodyLayer);
        event.registerLayerDefinition(ForceCubeModel.LAYER_LOCATION, ForceCubeModel::createBodyLayer);
        event.registerLayerDefinition(ForceTubeModel.LAYER_LOCATION, ForceTubeModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ForceFieldBlockModelLoader.NAME, (IGeometryLoader)new ForceFieldBlockModelLoader());
    }

    @SubscribeEvent
    public static void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        Block forceFieldBlock = (Block)ModBlocks.FORCE_FIELD.get();
        event.register((state, level, pos, tintIndex) -> {
            BlockState camo;
            BlockEntity be = level.getBlockEntity(pos);
            if (be != null && (camo = (BlockState)be.getModelData().get(ForceFieldBlockImpl.CAMOUFLAGE_BLOCK)) != null && !camo.is(forceFieldBlock)) {
                return event.getBlockColors().getColor(camo, level, pos, tintIndex);
            }
            return 3473151;
        }, new Block[]{forceFieldBlock});
    }

    @SubscribeEvent
    public static void onResourceReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> RenderPostProcessor.reloadPostProcessPass()));
    }

    private ModClientSetup() {
    }
}

