/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.world.features.resourcenode;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import rearth.oritech.Oritech;
import rearth.oritech.init.world.features.resourcenode.ResourceNodeFeatureConfig;

public class ResourceNodeFeature
extends Feature<ResourceNodeFeatureConfig> {
    public ResourceNodeFeature(Codec<ResourceNodeFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<ResourceNodeFeatureConfig> context) {
        BlockPos testPos;
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        if (world.isClientSide()) {
            return false;
        }
        boolean solidBlockFound = false;
        BlockPos deepNodePos = testPos = new BlockPos((Vec3i)origin);
        BlockPos boulderPos = testPos;
        for (int y = origin.getY(); y > world.getMinBuildHeight(); --y) {
            BlockPos downPos = testPos.below();
            BlockState testState = world.getBlockState(downPos);
            if (testState.is(Blocks.BEDROCK)) {
                deepNodePos = testPos;
                break;
            }
            if (testState.isRedstoneConductor((BlockGetter)world, downPos) && !solidBlockFound) {
                boulderPos = testPos = downPos;
                solidBlockFound = true;
                continue;
            }
            testPos = downPos;
        }
        if (!solidBlockFound || boulderPos.getY() < deepNodePos.getY() + 10) {
            return false;
        }
        if (Oritech.CONFIG.easyFindFeatures()) {
            this.placeSurfaceBoulder(boulderPos, context);
        }
        this.placeBedrockNode(deepNodePos, context);
        Oritech.LOGGER.debug("placing resource node at " + String.valueOf(boulderPos) + " with deep " + String.valueOf(deepNodePos));
        return true;
    }

    private BlockState getRandomBlockFromList(List<ResourceLocation> list, RandomSource random) {
        return ((Block)BuiltInRegistries.BLOCK.get(this.getRandomFromList(list, random))).defaultBlockState();
    }

    private ResourceLocation getRandomFromList(List<ResourceLocation> list, RandomSource random) {
        return list.get(random.nextInt(list.size()));
    }

    private void placeBedrockNode(BlockPos startPos, FeaturePlaceContext<ResourceNodeFeatureConfig> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        List<ResourceLocation> ores = ((ResourceNodeFeatureConfig)context.config()).nodeOres();
        int radius = ((ResourceNodeFeatureConfig)context.config()).nodeSize();
        BlockState overlayBlock = ((Block)BuiltInRegistries.BLOCK.get(((ResourceNodeFeatureConfig)context.config()).overlayBlock())).defaultBlockState();
        int overlayHeight = ((ResourceNodeFeatureConfig)context.config()).overlayHeight();
        ImprovedNoise noise = new ImprovedNoise(random);
        BlockPos centerPos = startPos.above(radius - 2);
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)centerPos, (int)radius, (int)radius, (int)radius)) {
            if (Math.sqrt(pos.distSqr((Vec3i)centerPos)) + noise.noise((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > (double)radius || (double)pos.getY() >= (double)(startPos.getY() + overlayHeight + 3) + noise.noise((double)pos.getX(), (double)(pos.getY() + 2), (double)pos.getZ())) continue;
            if (pos.getY() <= startPos.getY() + 1 && random.nextDouble() <= (double)((ResourceNodeFeatureConfig)context.config()).nodeOreChance()) {
                world.setBlock(pos, this.getRandomBlockFromList(ores, random), 16);
                continue;
            }
            if (pos.getY() > startPos.getY() + 1 && pos.getY() <= startPos.getY() + overlayHeight + 1) {
                world.setBlock(pos, overlayBlock, 16);
                continue;
            }
            if (pos.getY() <= startPos.getY() + 1) continue;
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 16);
        }
    }

    private void placeSurfaceBoulder(BlockPos startPos, FeaturePlaceContext<ResourceNodeFeatureConfig> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        int radius = ((ResourceNodeFeatureConfig)context.config()).boulderRadius();
        BlockPos movedCenter = startPos.relative(Direction.Axis.getRandom((RandomSource)random), random.nextIntBetweenInclusive(0, radius - 1));
        List<ResourceLocation> ores = ((ResourceNodeFeatureConfig)context.config()).boulderOres();
        ImprovedNoise noise = new ImprovedNoise(random);
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)movedCenter, (int)radius, (int)radius, (int)radius)) {
            if (Math.sqrt(pos.distSqr((Vec3i)movedCenter)) > (double)radius + noise.noise((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) continue;
            world.setBlock(pos, this.getRandomBlockFromList(ores, random), 16);
        }
    }
}

