/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.entity.reactor.ReactorControllerBlockEntity;
import rearth.oritech.client.init.ModScreens;

public class ReactorScreenHandler
extends AbstractContainerMenu {
    public final ReactorControllerBlockEntity reactorEntity;
    public final Level world;

    public ReactorScreenHandler(int syncId, Inventory inventory, FriendlyByteBuf buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.player.level().getBlockEntity(buf.readBlockPos())));
    }

    public ReactorScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity) {
        super(ModScreens.REACTOR_SCREEN, syncId);
        this.reactorEntity = (ReactorControllerBlockEntity)blockEntity;
        this.world = blockEntity.getLevel();
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.reactorEntity.sendUpdate(SyncType.GUI_TICK);
    }
}

