/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.ItemFilterScreen;
import rearth.oritech.client.ui.UpgradableMachineScreen;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.TooltipHelper;

public class EnergyStorageScreen
extends UpgradableMachineScreen<UpgradableMachineScreenHandler> {
    private LabelComponent inAvgSecond;
    private LabelComponent inLastTick;
    private LabelComponent inSources;
    private LabelComponent inPeak;
    private LabelComponent outAvgSecond;
    private LabelComponent outLastTick;
    private LabelComponent outPeak;
    private boolean showingOutput;

    public EnergyStorageScreen(UpgradableMachineScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        int panelXPos = 74;
        FlowLayout insertionContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)94), (Sizing)Sizing.content());
        insertionContainer.surface(Surface.PANEL_INSET);
        insertionContainer.padding(Insets.of((int)2, (int)2, (int)4, (int)8));
        insertionContainer.positioning(Positioning.absolute((int)panelXPos, (int)23));
        this.inAvgSecond = Components.label((Component)Component.literal((String)"X RF/t"));
        this.inAvgSecond.tooltip((Component)Component.translatable((String)"title.oritech.energy.inAvgSecond.tooltip"));
        this.inLastTick = Components.label((Component)Component.literal((String)"X RF/t"));
        this.inLastTick.tooltip((Component)Component.translatable((String)"title.oritech.energy.inLastTick.tooltip"));
        this.inSources = Components.label((Component)Component.literal((String)"X"));
        this.inSources.tooltip((Component)Component.translatable((String)"title.oritech.energy.inSources.tooltip"));
        this.inPeak = Components.label((Component)Component.literal((String)"X RF/t"));
        this.inPeak.tooltip((Component)Component.translatable((String)"title.oritech.energy.inPeak.tooltip"));
        insertionContainer.child((io.wispforest.owo.ui.core.Component)this.inLastTick.margins(Insets.of((int)2)));
        insertionContainer.child((io.wispforest.owo.ui.core.Component)this.inAvgSecond.margins(Insets.of((int)2)));
        insertionContainer.child((io.wispforest.owo.ui.core.Component)this.inPeak.margins(Insets.of((int)2)));
        insertionContainer.child((io.wispforest.owo.ui.core.Component)this.inSources.margins(Insets.of((int)2)));
        FlowLayout extractionContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)94), (Sizing)Sizing.content());
        extractionContainer.surface(Surface.PANEL_INSET);
        extractionContainer.padding(Insets.of((int)2, (int)2, (int)4, (int)8));
        extractionContainer.positioning(Positioning.absolute((int)panelXPos, (int)23));
        this.outAvgSecond = Components.label((Component)Component.literal((String)"X RF/t"));
        this.outAvgSecond.tooltip((Component)Component.translatable((String)"title.oritech.energy.outAvgSecond.tooltip"));
        this.outLastTick = Components.label((Component)Component.literal((String)"X RF/t"));
        this.outLastTick.tooltip((Component)Component.translatable((String)"title.oritech.energy.outLastTick.tooltip"));
        this.outPeak = Components.label((Component)Component.literal((String)"X RF/t"));
        this.outPeak.tooltip((Component)Component.translatable((String)"title.oritech.energy.outPeak.tooltip"));
        extractionContainer.child((io.wispforest.owo.ui.core.Component)this.outLastTick.margins(Insets.of((int)2)));
        extractionContainer.child((io.wispforest.owo.ui.core.Component)this.outAvgSecond.margins(Insets.of((int)2)));
        extractionContainer.child((io.wispforest.owo.ui.core.Component)this.outPeak.margins(Insets.of((int)2)));
        overlay.child((io.wispforest.owo.ui.core.Component)insertionContainer);
        ButtonComponent toggleButton = Components.button((Component)Component.literal((String)"                  ").append((Component)Component.translatable((String)"title.oritech.item_filter.toggle_energy_statistics").withColor(BasicMachineScreen.GRAY_TEXT_COLOR)), buttonComponent -> {
            boolean bl = this.showingOutput = !this.showingOutput;
            if (this.showingOutput) {
                overlay.removeChild((io.wispforest.owo.ui.core.Component)insertionContainer);
                overlay.child((io.wispforest.owo.ui.core.Component)extractionContainer);
            } else {
                overlay.removeChild((io.wispforest.owo.ui.core.Component)extractionContainer);
                overlay.child((io.wispforest.owo.ui.core.Component)insertionContainer);
            }
        });
        toggleButton.horizontalSizing(Sizing.fixed((int)60));
        toggleButton.renderer(ItemFilterScreen.createToggleRenderer(ignored -> this.showingOutput));
        toggleButton.textShadow(false);
        overlay.child(toggleButton.positioning(Positioning.absolute((int)panelXPos, (int)5)));
        BlockEntity blockEntity = ((UpgradableMachineScreenHandler)this.menu).blockEntity;
        if (blockEntity instanceof UnstableContainerBlockEntity) {
            UnstableContainerBlockEntity unstableContainer = (UnstableContainerBlockEntity)blockEntity;
            DynamicEnergyStorage container = (DynamicEnergyStorage)unstableContainer.getEnergyStorageForMultiblock(null);
            long capacity = container.maxInsert;
            float capacityMultiplier = (float)capacity / ((float)UnstableContainerBlockEntity.BASE_CAPACITY.longValue() * unstableContainer.qualityMultiplier);
            ItemComponent laserIcon = Components.item((ItemStack)new ItemStack((ItemLike)BlockContent.LASER_ARM_BLOCK.asItem()));
            LabelComponent laserLabel = Components.label((Component)Component.literal((String)("x" + String.format("%.1f", Float.valueOf(capacityMultiplier)))));
            List<MutableComponent> tooltipText = List.of(Component.translatable((String)"tooltip.oritech.unstable_laser_tooltip"), Component.translatable((String)"tooltip.oritech.unstable_laser_tooltip.2"));
            laserIcon.tooltip(tooltipText);
            laserLabel.tooltip(tooltipText);
            FlowLayout laserContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)44), (Sizing)Sizing.fixed((int)37));
            laserContainer.surface(Surface.PANEL_INSET);
            laserContainer.child((io.wispforest.owo.ui.core.Component)laserIcon.margins(Insets.of((int)2, (int)0, (int)0, (int)0)));
            laserContainer.child((io.wispforest.owo.ui.core.Component)laserLabel.margins(Insets.of((int)4, (int)2, (int)4, (int)4)));
            laserContainer.horizontalAlignment(HorizontalAlignment.CENTER);
            overlay.child((io.wispforest.owo.ui.core.Component)laserContainer.positioning(Positioning.absolute((int)27, (int)5)));
            ItemComponent containedIcon = Components.item((ItemStack)new ItemStack((ItemLike)unstableContainer.capturedBlock.getBlock().asItem()));
            LabelComponent containedLabel = Components.label((Component)Component.literal((String)("x" + unstableContainer.qualityMultiplier)));
            MutableComponent containedTooltipText = Component.translatable((String)"tooltip.oritech.unstable_contained_tooltip");
            containedIcon.tooltip((Component)containedTooltipText);
            containedLabel.tooltip((Component)containedTooltipText);
            FlowLayout containedContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)44), (Sizing)Sizing.content());
            containedContainer.surface(Surface.PANEL_INSET);
            containedContainer.child((io.wispforest.owo.ui.core.Component)containedIcon.margins(Insets.of((int)2, (int)0, (int)0, (int)0)));
            containedContainer.child((io.wispforest.owo.ui.core.Component)containedLabel.margins(Insets.of((int)4, (int)2, (int)4, (int)4)));
            containedContainer.horizontalAlignment(HorizontalAlignment.CENTER);
            overlay.child((io.wispforest.owo.ui.core.Component)containedContainer.positioning(Positioning.absolute((int)27, (int)46)));
        }
    }

    @Override
    protected void containerTick() {
        boolean updateAll;
        DynamicStatisticEnergyStorage.EnergyStatistics statistics;
        super.containerTick();
        BlockEntity entity = ((UpgradableMachineScreenHandler)this.menu).blockEntity;
        DynamicStatisticEnergyStorage.EnergyStatistics energyStatistics = statistics = entity instanceof ExpandableEnergyStorageBlockEntity ? ((ExpandableEnergyStorageBlockEntity)entity).currentStats : ((UnstableContainerBlockEntity)entity).currentStats;
        if (statistics == null) {
            return;
        }
        boolean bl = updateAll = ((UpgradableMachineScreenHandler)this.menu).worldAccess.getGameTime() % 4L == 0L;
        if (updateAll) {
            this.inAvgSecond.text((Component)Component.translatable((String)"title.oritech.energy.inAvgSecond", (Object[])new Object[]{TooltipHelper.getEnergyText((long)statistics.avgInsertSecond())}));
            this.inSources.text((Component)Component.translatable((String)"title.oritech.energy.inSources", (Object[])new Object[]{statistics.insertionCountLastTick()}));
            this.inPeak.text((Component)Component.translatable((String)"title.oritech.energy.inPeak", (Object[])new Object[]{TooltipHelper.getEnergyText(statistics.maxInsertSecond())}));
            this.outAvgSecond.text((Component)Component.translatable((String)"title.oritech.energy.outAvgSecond", (Object[])new Object[]{TooltipHelper.getEnergyText((long)statistics.avgExtractSecond())}));
            this.outPeak.text((Component)Component.translatable((String)"title.oritech.energy.outPeak", (Object[])new Object[]{TooltipHelper.getEnergyText(statistics.maxExtractSecond())}));
        }
        this.inLastTick.text((Component)Component.translatable((String)"title.oritech.energy.inLastTick", (Object[])new Object[]{TooltipHelper.getEnergyText(statistics.insertedLastTickTotal())}));
        this.outLastTick.text((Component)Component.translatable((String)"title.oritech.energy.outLastTick", (Object[])new Object[]{TooltipHelper.getEnergyText(statistics.extractedLastTickTotal())}));
    }

    @Override
    public boolean useHighTitle() {
        return true;
    }

    @Override
    public ItemStack getTitleIcon() {
        if (((UpgradableMachineScreenHandler)this.menu).blockEntity instanceof UnstableContainerBlockEntity) {
            return new ItemStack((ItemLike)ItemContent.UNSTABLE_CONTAINER);
        }
        return super.getTitleIcon();
    }
}

