/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import rearth.oritech.Oritech;
import rearth.oritech.OritechClient;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.ui.PlayerModifierScreen;

public class AugmentSelectionScreen
extends BaseOwoScreen<FlowLayout> {
    private io.wispforest.owo.ui.core.Component lastFocused;
    private LabelComponent noOpButton;
    private FlowLayout root;
    private final List<io.wispforest.owo.ui.core.Component> augments = new ArrayList<io.wispforest.owo.ui.core.Component>();
    private final HashMap<io.wispforest.owo.ui.core.Component, ResourceLocation> augmentIDs = new HashMap();
    private final HashMap<io.wispforest.owo.ui.core.Component, Float> augmentSizes = new HashMap();

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.root = rootComponent;
        this.addAugments(rootComponent);
        LabelComponent label = Components.label((Component)Component.translatable((String)"oritech.text.augment_toggle"));
        rootComponent.child((io.wispforest.owo.ui.core.Component)label.positioning(Positioning.relative((int)2, (int)90)));
    }

    public void tick() {
        io.wispforest.owo.ui.core.Component component;
        super.tick();
        if (this.lastFocused == this.noOpButton) {
            this.noOpButton.text((Component)Component.literal((String)"Exit"));
        } else if (this.lastFocused != null && (component = this.lastFocused) instanceof TextureComponent) {
            TextureComponent lastButton = (TextureComponent)component;
            ResourceLocation focusedAugmentId = this.augmentIDs.get(lastButton);
            if (focusedAugmentId == null) {
                return;
            }
            MutableComponent focusedAugment = Component.translatable((String)PlayerModifierScreen.augmentKey(focusedAugmentId));
            this.noOpButton.text((Component)focusedAugment);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Vector2i mousePos;
        super.render(context, mouseX, mouseY, delta);
        if (this.augments.isEmpty()) {
            return;
        }
        io.wispforest.owo.ui.core.Component mousingOver = (io.wispforest.owo.ui.core.Component)this.augments.stream().findFirst().get();
        int minDist = Integer.MAX_VALUE;
        for (io.wispforest.owo.ui.core.Component augment : this.augments) {
            mousePos = new Vector2i(mouseX, mouseY);
            Vector2i augmentPos = new Vector2i(augment.x() + augment.width() / 2, augment.y() + augment.height() / 2);
            double dist = mousePos.distance((Vector2ic)augmentPos);
            if (augment == this.noOpButton) {
                dist *= 2.0;
            }
            if (!(dist < (double)minDist)) continue;
            minDist = (int)dist;
            mousingOver = augment;
        }
        this.lastFocused = mousingOver;
        Vector2i centerPos = new Vector2i(this.noOpButton.x() + this.noOpButton.width() / 2, this.noOpButton.y() + this.noOpButton.height() / 2);
        Vector2i selectedPos = new Vector2i(this.lastFocused.x() + this.lastFocused.width() / 2, this.lastFocused.y() + this.lastFocused.height() / 2);
        mousePos = new Vector2i(mouseX, mouseY);
        int mouseLineColor = new Color(0.5882353f, 0.7058824f, 0.8627451f, 0.8f).argb();
        AugmentSelectionScreen.drawLine(context, centerPos, selectedPos, mouseLineColor);
        AugmentSelectionScreen.drawLine(context, selectedPos, mousePos, mouseLineColor);
        int screenSize = this.root.height();
        double innerRadius = 0.175;
        double outerRadius = 0.4;
        int screenSizeX = this.root.width();
        int screenSizeY = this.root.height();
        float middleX = (float)screenSizeX / 2.0f;
        float middleY = (float)screenSizeY / 2.0f;
        int augmentCount = this.augments.size() - 1;
        double radSizePerElement = Math.toRadians(360.0 / (double)augmentCount) * (double)0.8f;
        Vector2i screenMiddle = new Vector2i((int)middleX, (int)middleY);
        for (int i = 0; i < this.augments.size(); ++i) {
            io.wispforest.owo.ui.core.Component augment = this.augments.get(i);
            ResourceLocation augmentId = this.augmentIDs.get(augment);
            Augment augmentData = PlayerAugments.allAugments.get(augmentId);
            if (augmentData == null) continue;
            boolean isEnabled = augmentData.isEnabled((Player)this.minecraft.player);
            boolean active = mousingOver == augment;
            int color = new Color(0.7058824f, 0.11764706f, 0.11764706f, 0.3f).argb();
            if (isEnabled) {
                color = new Color(0.11764706f, 0.7058824f, 0.11764706f, 0.3f).argb();
            }
            if (active) {
                color = new Color(0.627451f, 0.7058824f, 0.8627451f, 0.5f).argb();
            }
            double augmentRad = (double)((float)i / (float)augmentCount * 2.0f) * Math.PI - Math.toRadians(90.0);
            float sizeTarget = 1.0f;
            if (active) {
                sizeTarget = 1.05f;
            }
            Float lastSize = this.augmentSizes.getOrDefault(augment, Float.valueOf(1.0f));
            double usedSize = Mth.lerp((double)0.15, (double)lastSize.floatValue(), (double)sizeTarget);
            this.augmentSizes.put(augment, Float.valueOf((float)usedSize));
            double activeInnerRadius = innerRadius / usedSize;
            double activeOuterRadius = outerRadius * usedSize;
            if (i == this.augments.size() - 1) continue;
            AugmentSelectionScreen.drawPieSegmented(context, augmentRad, radSizePerElement, screenMiddle, activeInnerRadius, activeOuterRadius, screenSize, color, 16);
        }
        boolean centerSelected = mousingOver == this.noOpButton;
        int color = new Color(0.627451f, 0.7058824f, 0.7058824f, 0.3f).argb();
        if (centerSelected) {
            color = new Color(0.627451f, 0.7058824f, 0.8627451f, 0.5f).argb();
        }
        AugmentSelectionScreen.drawPieSegmented(context, 0.0, Math.toRadians(360.0), screenMiddle, 0.0, innerRadius * 0.6, screenSize, color, 32);
    }

    private static void drawPieSegmented(GuiGraphics context, double augmentRad, double radSize, Vector2i screenMiddle, double innerRadius, double outerRadius, double screenSize, int color, int segmentCount) {
        double segmentSize = radSize / (double)segmentCount;
        double augmentRadBegin = augmentRad - radSize * 0.5;
        for (int i = 0; i < segmentCount; ++i) {
            double fromRad = augmentRadBegin + segmentSize * (double)i;
            double toRad = fromRad + segmentSize;
            Vector2i a = new Vector2i((Vector2ic)screenMiddle).add((Vector2ic)new Vector2i((int)(innerRadius * Math.cos(fromRad) * screenSize), (int)(innerRadius * Math.sin(fromRad) * screenSize)));
            Vector2i b = new Vector2i((Vector2ic)screenMiddle).add((Vector2ic)new Vector2i((int)(outerRadius * Math.cos(fromRad) * screenSize), (int)(outerRadius * Math.sin(fromRad) * screenSize)));
            Vector2i c = new Vector2i((Vector2ic)screenMiddle).add((Vector2ic)new Vector2i((int)(innerRadius * Math.cos(toRad) * screenSize), (int)(innerRadius * Math.sin(toRad) * screenSize)));
            Vector2i d = new Vector2i((Vector2ic)screenMiddle).add((Vector2ic)new Vector2i((int)(outerRadius * Math.cos(toRad) * screenSize), (int)(outerRadius * Math.sin(toRad) * screenSize)));
            AugmentSelectionScreen.drawRect(context, d, b, a, c, color);
        }
    }

    private static void drawLine(GuiGraphics context, Vector2i from, Vector2i to, int color) {
        if ((double)from.distanceSquared((Vector2ic)to) < 0.1) {
            return;
        }
        PoseStack matrices = context.pose();
        matrices.pushPose();
        Matrix4f pos = matrices.last().pose();
        Vector2f normal = AugmentSelectionScreen.getNormalVector(from, to).normalize();
        Vector2f offset = normal.mul(1.0f);
        boolean zIndex = false;
        VertexConsumer buffer = context.bufferSource().getBuffer(RenderType.gui());
        buffer.addVertex(pos, (float)from.x - offset.x, (float)from.y - offset.y, (float)zIndex).setColor(color);
        buffer.addVertex(pos, (float)from.x + offset.x, (float)from.y + offset.y, (float)zIndex).setColor(color);
        buffer.addVertex(pos, (float)to.x + offset.x, (float)to.y + offset.y, (float)zIndex).setColor(color);
        buffer.addVertex(pos, (float)to.x - offset.x, (float)to.y - offset.y, (float)zIndex).setColor(color);
        context.flush();
        matrices.popPose();
    }

    private static void drawRect(GuiGraphics context, Vector2i a, Vector2i b, Vector2i c, Vector2i d, int color) {
        PoseStack matrices = context.pose();
        matrices.pushPose();
        Matrix4f pos = matrices.last().pose();
        boolean zIndex = false;
        VertexConsumer buffer = context.bufferSource().getBuffer(RenderType.gui());
        buffer.addVertex(pos, (float)a.x, (float)a.y, (float)zIndex).setColor(color);
        buffer.addVertex(pos, (float)b.x, (float)b.y, (float)zIndex).setColor(color);
        buffer.addVertex(pos, (float)c.x, (float)c.y, (float)zIndex).setColor(color);
        buffer.addVertex(pos, (float)d.x, (float)d.y, (float)zIndex).setColor(color);
        context.flush();
        matrices.popPose();
    }

    public static Vector2f getNormalVector(Vector2i point1, Vector2i point2) {
        int dx = point2.x - point1.x;
        int dy = point2.y - point1.y;
        return new Vector2f((float)(-dy), (float)dx);
    }

    private void addAugments(FlowLayout parent) {
        LocalPlayer player = Objects.requireNonNull(this.minecraft).player;
        ArrayList<Augment> augmentsToAdd = new ArrayList<Augment>();
        for (Augment augment : PlayerAugments.allAugments.values()) {
            boolean isInstalled = augment.isInstalled((Player)player);
            boolean isToggleable = augment.toggleable;
            if (!isInstalled || !isToggleable) continue;
            augmentsToAdd.add(augment);
        }
        int augmentCount = augmentsToAdd.size();
        int radius = 30;
        int screenSizeX = this.width;
        int screenSizeY = this.height;
        float sideRelative = (float)screenSizeY / (float)screenSizeX;
        for (int i = 0; i < augmentsToAdd.size(); ++i) {
            Augment augment = (Augment)augmentsToAdd.get(i);
            double angleRad = (double)((float)i / (float)augmentCount * 2.0f) * Math.PI - Math.toRadians(90.0);
            double offsetX = (double)radius * Math.cos(angleRad);
            double offsetY = (double)radius * Math.sin(angleRad);
            ResourceLocation id = augment.id;
            ResourceLocation iconTexture = Oritech.id("textures/gui/" + id.getPath() + ".png");
            TextureComponent label = Components.texture((ResourceLocation)iconTexture, (int)0, (int)0, (int)24, (int)24, (int)24, (int)24);
            label.positioning(Positioning.relative((int)((int)(50.0 + offsetX * (double)sideRelative)), (int)((int)(50.0 + offsetY))));
            label.sizing(Sizing.fixed((int)(screenSizeY / 12)));
            this.augments.add((io.wispforest.owo.ui.core.Component)label);
            parent.child((io.wispforest.owo.ui.core.Component)label);
            this.augmentIDs.put((io.wispforest.owo.ui.core.Component)label, id);
            this.augmentSizes.put((io.wispforest.owo.ui.core.Component)label, Float.valueOf(1.0f));
        }
        LabelComponent noOpLabel = Components.label((Component)Component.literal((String)"Nothing"));
        noOpLabel.positioning(Positioning.relative((int)50, (int)50));
        this.augments.add((io.wispforest.owo.ui.core.Component)noOpLabel);
        this.noOpButton = noOpLabel;
        parent.child((io.wispforest.owo.ui.core.Component)noOpLabel);
    }

    private void toggleAugment(ResourceLocation id) {
        NetworkManager.sendToServer(new PlayerAugments.AugmentPlayerTogglePacket(id));
    }

    public void onClose() {
        if (this.lastFocused != null && this.augmentIDs.containsKey(this.lastFocused)) {
            ResourceLocation id = this.augmentIDs.get(this.lastFocused);
            this.toggleAugment(id);
        }
        OritechClient.activeScreen = null;
        super.onClose();
    }
}

