/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.SimpleCraftingInventory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DeepDrillEntity
extends NetworkedBlockEntity
implements EnergyApi.BlockProvider,
GeoBlockEntity,
ItemApi.BlockProvider,
MultiblockMachineController {
    private boolean initialized;
    private final List<Block> targetedOre = new ArrayList<Block>();
    private int progress;
    @SyncField
    private long lastWorkTime;
    private final int worktime;
    private final int energyPerStep;
    protected final DynamicEnergyStorage energyStorage;
    public final SimpleInventoryStorage inventory;
    private final ArrayList<BlockPos> coreBlocksConnected;
    private float coreQuality;
    protected final AnimatableInstanceCache animatableInstanceCache;
    private final AnimationController<DeepDrillEntity> animationController;

    public DeepDrillEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.DEEP_DRILL_ENTITY, pos, state);
        this.worktime = Oritech.CONFIG.deepDrillConfig.stepsPerOre();
        this.energyPerStep = Oritech.CONFIG.deepDrillConfig.energyPerStep();
        this.energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.deepDrillConfig.energyCapacity(), 0L, 0L, this::setChanged);
        this.inventory = new SimpleInventoryStorage(1, this::setChanged);
        this.coreBlocksConnected = new ArrayList();
        this.coreQuality = 1.0f;
        this.animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.animationController = this.getAnimationController();
    }

    public boolean init(boolean manual) {
        this.initialized = true;
        this.targetedOre.clear();
        this.loadOreBlocks(manual);
        return !this.targetedOre.isEmpty();
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (this.isActive(state) && !this.initialized && (world.getGameTime() + pos.asLong()) % 60L == 0L) {
            this.init(false);
        }
        if (world.isClientSide() || !this.initialized || this.targetedOre.isEmpty()) {
            return;
        }
        if (!this.inventory.isEmpty() && ((ItemStack)this.inventory.heldStacks.get(0)).getCount() >= ((ItemStack)this.inventory.heldStacks.get(0)).getMaxStackSize()) {
            return;
        }
        if (this.energyStorage.amount >= (long)this.energyPerStep) {
            ++this.progress;
            this.energyStorage.amount -= (long)this.energyPerStep;
            this.lastWorkTime = world.getGameTime();
            this.setChanged();
            BlockPos particlePos = this.getCenter(0);
            ParticleContent.FURNACE_BURNING.spawn(world, Vec3.atLowerCornerOf((Vec3i)particlePos), (Object)1);
        }
        for (int i = 0; i < 5; ++i) {
            if (this.energyStorage.amount < (long)this.energyPerStep) continue;
            ++this.progress;
            this.energyStorage.amount -= (long)this.energyPerStep;
        }
        if (this.progress >= this.worktime) {
            this.craftResult(world, pos);
            this.progress -= this.worktime;
            this.setChanged();
        }
    }

    private BlockPos getCenter(int y) {
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return this.worldPosition.offset(Geometry.rotatePosition(new Vec3i(1, y, 0), facing));
    }

    private void loadOreBlocks(boolean manual) {
        BlockPos center = this.getCenter(-1);
        for (int x = -1; x <= 1; ++x) {
            block1: for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y >= -2; --y) {
                    BlockPos target = center.offset(x, y, z);
                    BlockState targetState = this.level.getBlockState(target);
                    if (targetState.is(TagContent.RESOURCE_NODES)) {
                        if (manual) {
                            ParticleContent.DEBUG_BLOCK.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)target));
                        }
                        this.targetedOre.add(targetState.getBlock());
                        continue block1;
                    }
                    if (!targetState.isAir()) continue block1;
                }
            }
        }
    }

    private void craftResult(Level world, BlockPos pos) {
        Block usedOre = this.targetedOre.get(world.random.nextInt(0, this.targetedOre.size()));
        Item nodeOreBlockItem = usedOre.asItem();
        SimpleCraftingInventory sampleInv = new SimpleCraftingInventory(new ItemStack((ItemLike)nodeOreBlockItem, 1));
        Optional recipeCandidate = world.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.DEEP_DRILL, (RecipeInput)sampleInv, world);
        if (recipeCandidate.isEmpty()) {
            return;
        }
        ItemStack output = ((OritechRecipe)((RecipeHolder)recipeCandidate.get()).value()).getResults().get(0);
        this.inventory.insert(output, false);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        this.addMultiblockToNbt(nbt);
        nbt.putLong("energy_stored", this.energyStorage.amount);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.energyStorage.amount = nbt.getLong("energy_stored");
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, -1), new Vec3i(-2, 0, 1), new Vec3i(-2, 0, 0), new Vec3i(-2, 0, -1), new Vec3i(0, 1, 1), new Vec3i(0, 1, 0), new Vec3i(0, 1, -1), new Vec3i(-1, 1, 1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, -1), new Vec3i(-2, 1, 1), new Vec3i(-2, 1, 0), new Vec3i(-2, 1, -1), new Vec3i(0, 2, 1), new Vec3i(0, 2, 0), new Vec3i(0, 2, -1), new Vec3i(-1, 2, 1), new Vec3i(-1, 2, 0), new Vec3i(-1, 2, -1), new Vec3i(-2, 2, 1), new Vec3i(-2, 2, 0), new Vec3i(-2, 2, -1));
    }

    @Override
    public Direction getFacingForMultiblock() {
        BlockState state = this.getBlockState();
        return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
    }

    @Override
    public BlockPos getPosForMultiblock() {
        return this.worldPosition;
    }

    @Override
    public Level getWorldForMultiblock() {
        return this.level;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return null;
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("base_controller", "setup");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<DeepDrillEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.getBlockState())) {
                long idleTime = this.level.getGameTime() - this.lastWorkTime;
                if (idleTime < 60L) {
                    return state.setAndContinue(MachineBlockEntity.WORKING);
                }
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()).triggerableAnim("setup", MachineBlockEntity.SETUP);
    }

    public void setLastWorkTime(long lastWorkTime) {
        this.lastWorkTime = lastWorkTime;
    }

    private boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
    }
}

