/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.StackContext;

public class ChargerBlockEntity
extends NetworkedBlockEntity
implements FluidApi.BlockProvider,
EnergyApi.BlockProvider,
ItemApi.BlockProvider,
ScreenProvider,
ExtendedMenuProvider {
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    protected final DynamicEnergyStorage energyStorage;
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    private final SimpleFluidStorage fluidStorage;
    public final InOutInventoryStorage inventory;

    public ChargerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.CHARGER_BLOCK_ENTITY, pos, state);
        this.energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.charger.energyCapacity(), Oritech.CONFIG.charger.maxEnergyInsertion(), Oritech.CONFIG.charger.maxEnergyExtraction(), this::setChanged);
        this.fluidStorage = new SimpleFluidStorage(16L * FluidStackHooks.bucketAmount(), this::setChanged);
        this.inventory = new InOutInventoryStorage(2, this::setChanged, new InventorySlotAssignment(0, 1, 1, 1));
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        ItemStack outSlot;
        if (world.isClientSide) {
            return;
        }
        if (this.inventory.getItem(0).isEmpty() || this.inventory.getItem(0).getCount() > 1) {
            return;
        }
        boolean isFull = true;
        long startEnergy = this.energyStorage.amount;
        long startFluid = this.fluidStorage.getAmount();
        if (!this.chargeItems()) {
            isFull = false;
        }
        if (!this.fillItems()) {
            isFull = false;
        }
        if (isFull && (outSlot = this.inventory.getItem(1)).isEmpty()) {
            this.inventory.setItem(1, this.inventory.getItem(0));
            this.inventory.setItem(0, ItemStack.EMPTY);
        }
        if (this.fluidStorage.getAmount() != startFluid || this.energyStorage.amount != startEnergy) {
            ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.getCenter().add(0.1, 0.1, 0.0), (Object)1);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putLong("energy_stored", this.energyStorage.amount);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.energyStorage.amount = nbt.getLong("energy_stored");
    }

    private boolean chargeItems() {
        ItemStack heldStack = (ItemStack)this.inventory.heldStacks.get(0);
        StackContext stackRef = new StackContext(heldStack, updated -> this.inventory.heldStacks.set(0, updated));
        EnergyApi.EnergyStorage slotEnergyContainer = EnergyApi.ITEM.find(stackRef);
        if (slotEnergyContainer != null) {
            EnergyApi.transfer(this.energyStorage, slotEnergyContainer, Long.MAX_VALUE, false);
            return slotEnergyContainer.getAmount() >= slotEnergyContainer.getCapacity();
        }
        return true;
    }

    private boolean fillItems() {
        ItemStack heldStack = (ItemStack)this.inventory.heldStacks.get(0);
        StackContext stackRef = new StackContext(heldStack, updated -> this.inventory.heldStacks.set(0, updated));
        FluidApi.FluidStorage slotFluidContainer = FluidApi.ITEM.find(stackRef);
        if (slotFluidContainer != null) {
            long moved = FluidApi.transferFirst(this.fluidStorage, slotFluidContainer, (long)((float)FluidStackHooks.bucketAmount() * 0.1f), false);
            return this.fluidStorage.getAmount() > 0L && moved == 0L;
        }
        return true;
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.CHARGER_SCREEN;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 117, 38));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 1024.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showArmor() {
        return true;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable Direction direction) {
        return this.fluidStorage;
    }
}

