/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.addons;

import com.mojang.serialization.MapCodec;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.EnergyAcceptorAddonBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.TooltipHelper;

public class MachineAddonBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock {
    public static final Boolean USE_ACCURATE_OUTLINES = Oritech.CONFIG.tightMachineAddonHitboxes();
    public static final BooleanProperty ADDON_USED = BooleanProperty.create((String)"addon_used");
    protected final AddonSettings addonSettings;
    public static VoxelShape[][] MACHINE_ACCEPTOR_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_CAPACITOR_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_PROCESSING_ADDON_SHAPE;
    public static VoxelShape[][] CROP_FILTER_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_EFFICIENCY_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_FLUID_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_INVENTORY_PROXY_ADDON_SHAPE;
    public static VoxelShape[][] QUARRY_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_HUNTER_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_REDSTONE_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_SPEED_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_ULTIMATE_ADDON_SHAPE;
    public static VoxelShape[][] STEAM_BOILER_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_YIELD_ADDON_SHAPE;
    public static VoxelShape[][] MACHINE_SILK_TOUCH_ADDON_SHAPE;
    private static boolean constructorAssignmentSupportWorkaround;

    private static BlockBehaviour.Properties doConstructorWorkaround(BlockBehaviour.Properties settings, boolean needsSupport) {
        constructorAssignmentSupportWorkaround = needsSupport;
        return settings;
    }

    public MachineAddonBlock(BlockBehaviour.Properties settings, AddonSettings addonSettings) {
        super(MachineAddonBlock.doConstructorWorkaround(settings, addonSettings.needsSupport()));
        this.addonSettings = addonSettings;
        if (addonSettings.needsSupport()) {
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ADDON_USED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.FLOOR));
        } else {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ADDON_USED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (world.isClientSide) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos controllerPos;
            BlockEntity blockEntity;
            AddonBlockEntity addonEntity;
            BlockState addonState;
            Boolean addonConnected;
            BlockPos checkPos = pos.offset(direction.getNormal());
            BlockEntity checkEntity = world.getBlockEntity(checkPos);
            if (checkEntity instanceof MachineAddonController) {
                MachineAddonController machineEntity = (MachineAddonController)checkEntity;
                AddonBlockEntity.pendingInits.add(machineEntity);
                break;
            }
            if (checkEntity instanceof ItemEnergyFrameInteractionBlockEntity) {
                ItemEnergyFrameInteractionBlockEntity machineEntity = (ItemEnergyFrameInteractionBlockEntity)checkEntity;
                AddonBlockEntity.pendingInits.add(machineEntity);
                break;
            }
            if (checkEntity instanceof MachineCoreEntity) {
                MultiblockMachineController multiblockMachineController;
                MachineCoreEntity machineEntity = (MachineCoreEntity)checkEntity;
                if (!machineEntity.isEnabled() || !((multiblockMachineController = machineEntity.getCachedController()) instanceof MachineAddonController)) break;
                MachineAddonController addonController = (MachineAddonController)((Object)multiblockMachineController);
                AddonBlockEntity.pendingInits.add(addonController);
                break;
            }
            if (!(checkEntity instanceof AddonBlockEntity) || !(addonConnected = (Boolean)(addonState = (addonEntity = (AddonBlockEntity)checkEntity).getBlockState()).getValue((Property)ADDON_USED)).booleanValue() || !((blockEntity = world.getBlockEntity(controllerPos = addonEntity.getControllerPos())) instanceof MachineAddonController)) continue;
            MachineAddonController controllerEntity = (MachineAddonController)blockEntity;
            AddonBlockEntity.pendingInits.add(controllerEntity);
            break;
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ADDON_USED});
        if (constructorAssignmentSupportWorkaround) {
            builder.add(new Property[]{FACING});
            builder.add(new Property[]{FACE});
        }
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        if (!state.hasProperty((Property)FACING)) {
            return state;
        }
        return super.rotate(state, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (!state.hasProperty((Property)FACING)) {
            return state;
        }
        return super.mirror(state, mirror);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        if (this.addonSettings.needsSupport) {
            return super.getStateForPlacement(ctx);
        }
        return this.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (this.addonSettings.needsSupport) {
            return super.canSurvive(state, world, pos);
        }
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.addonSettings.needsSupport) {
            return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        }
        return state;
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!USE_ACCURATE_OUTLINES.booleanValue() || !this.addonSettings.needsSupport() || this.addonSettings.boundingShape() == null) {
            return super.getShape(state, world, pos, context);
        }
        return this.addonSettings.boundingShape()[((Direction)state.getValue((Property)FACING)).ordinal()][((AttachFace)state.getValue((Property)FACE)).ordinal()];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        try {
            return this.getBlockEntityType().getDeclaredConstructor(BlockPos.class, BlockState.class).newInstance(pos, state);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Oritech.LOGGER.error("Unable to create blockEntity for " + this.getBlockEntityType().getSimpleName() + " at " + String.valueOf((Object)this));
            return new AddonBlockEntity(pos, state);
        }
    }

    @NotNull
    public Class<? extends BlockEntity> getBlockEntityType() {
        return this.addonSettings.acceptEnergy ? EnergyAcceptorAddonBlockEntity.class : AddonBlockEntity.class;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        AddonBlockEntity ownEntity;
        BlockEntity controllerEntity;
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)ADDON_USED)).booleanValue() && (controllerEntity = world.getBlockEntity(Objects.requireNonNull(ownEntity = (AddonBlockEntity)world.getBlockEntity(pos)).getControllerPos())) instanceof MachineAddonController) {
            MachineAddonController machineEntity = (MachineAddonController)controllerEntity;
            machineEntity.initAddons(pos);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public AddonSettings getAddonSettings() {
        return this.addonSettings;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        boolean showExtra = Screen.hasControlDown();
        if (showExtra) {
            BlockItem item;
            Block blockType;
            int displayedNumber;
            if (this.addonSettings.speedMultiplier() != 1.0f) {
                displayedNumber = Math.round((1.0f - this.addonSettings.speedMultiplier()) * 100.0f);
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_speed_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
            }
            if (this.addonSettings.efficiencyMultiplier() != 1.0f) {
                displayedNumber = Math.round((1.0f - this.addonSettings.efficiencyMultiplier()) * 100.0f);
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_efficiency_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
            }
            if (this.addonSettings.addedCapacity() != 0L) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_capacity_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedEnergyChangeTooltip(this.addonSettings.addedCapacity(), " RF")));
            }
            if (this.addonSettings.addedInsert() != 0L) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_transfer_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedEnergyChangeTooltip(this.addonSettings.addedInsert(), " RF/t")));
            }
            if ((blockType = (item = (BlockItem)stack.getItem()).getBlock()) == BlockContent.MACHINE_YIELD_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_yield_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.MACHINE_FLUID_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_fluid_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.MACHINE_ACCEPTOR_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_acceptor_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.STEAM_BOILER_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_boiler_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.CROP_FILTER_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_crop_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.MACHINE_INVENTORY_PROXY_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_proxy_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.QUARRY_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_quarry_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.MACHINE_HUNTER_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_hunter_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.MACHINE_REDSTONE_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_redstone_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.MACHINE_PROCESSING_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.processing_addon_desc").withStyle(ChatFormatting.GRAY));
            }
            if (blockType == BlockContent.MACHINE_SILK_TOUCH_ADDON) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_silk_touch_desc").withStyle(ChatFormatting.GRAY));
            }
            if (this.addonSettings.extender()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_extender_desc").withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }

    static {
        constructorAssignmentSupportWorkaround = false;
        MACHINE_ACCEPTOR_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_CAPACITOR_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_PROCESSING_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_ULTIMATE_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        CROP_FILTER_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_EFFICIENCY_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_FLUID_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_INVENTORY_PROXY_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        QUARRY_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_HUNTER_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_REDSTONE_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_SPEED_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        STEAM_BOILER_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_YIELD_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        MACHINE_SILK_TOUCH_ADDON_SHAPE = new VoxelShape[Direction.values().length][AttachFace.values().length];
        for (Direction facing : Direction.values()) {
            if (!facing.getAxis().isHorizontal()) continue;
            for (AttachFace face : AttachFace.values()) {
                MachineAddonBlock.MACHINE_ACCEPTOR_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.625, (double)0.25, (double)0.75, (double)0.75, (double)0.75), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.25, (double)0.125, (double)0.875, (double)0.375, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.375, (double)0.125, (double)0.875, (double)0.5, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.5, (double)0.125, (double)0.875, (double)0.625, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)0.875, (double)1.0), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.875, (double)0.125, (double)0.875, (double)1.0, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.625, (double)0.1875, (double)0.8125, (double)0.75, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)0.25, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.3125, (double)0.0625, (double)0.0625, (double)0.6875, (double)0.8125, (double)0.1875), facing, face)});
                MachineAddonBlock.MACHINE_CAPACITOR_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.1875, (double)0.3125, (double)0.25, (double)0.375, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.4375, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.75, (double)0.125, (double)0.1875, (double)0.8125, (double)0.5, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5625, (double)0.4375, (double)0.25, (double)0.625, (double)0.5, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.6875, (double)0.4375, (double)0.25, (double)0.75, (double)0.5, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.3125, (double)0.4375, (double)0.25, (double)0.375, (double)0.5, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.4375, (double)0.25, (double)0.5, (double)0.5, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5625, (double)0.125, (double)0.1875, (double)0.625, (double)0.5, (double)0.25), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.6875, (double)0.125, (double)0.1875, (double)0.75, (double)0.5, (double)0.25), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.3125, (double)0.125, (double)0.1875, (double)0.375, (double)0.5, (double)0.25), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.125, (double)0.1875, (double)0.5, (double)0.5, (double)0.25), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.125, (double)0.75, (double)0.75, (double)0.5, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.8125, (double)0.25, (double)0.5625, (double)0.875, (double)0.4375, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.8125, (double)0.25, (double)0.3125, (double)0.875, (double)0.4375, (double)0.4375), facing, face)});
                MachineAddonBlock.CROP_FILTER_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.125, (double)0.1875, (double)0.875, (double)0.25, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.25, (double)0.1875, (double)0.875, (double)0.5625, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5625, (double)0.3125, (double)0.1875, (double)0.75, (double)0.4375, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5625, (double)0.125, (double)0.8125, (double)0.75, (double)0.4375, (double)0.9375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.375, (double)0.25, (double)0.875), facing, face)});
                MachineAddonBlock.MACHINE_EFFICIENCY_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.125, (double)0.75), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.125, (double)0.1875, (double)0.75, (double)0.4375, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.75, (double)0.125, (double)0.125, (double)0.875, (double)0.5, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.25, (double)0.5, (double)0.875), facing, face)});
                MachineAddonBlock.MACHINE_PROCESSING_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.25, (double)0.25, (double)0.875, (double)0.75, (double)0.75), facing, face));
                MachineAddonBlock.MACHINE_ULTIMATE_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.875, (double)1.0, (double)0.75), facing, face));
                MachineAddonBlock.MACHINE_FLUID_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.3125, (double)6.25E-4, (double)0.25, (double)0.6875, (double)0.125625, (double)0.75), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.00125, (double)0.3125, (double)0.75, (double)0.12625, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.3125, (double)0.1875, (double)0.375, (double)0.625, (double)0.5625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5625, (double)0.3125, (double)0.1875, (double)0.9375, (double)0.625, (double)0.5625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.3125, (double)0.5, (double)0.625, (double)0.4375, (double)1.0, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.3125, (double)0.375, (double)0.625, (double)0.75, (double)0.5, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.625, (double)0.375, (double)0.5, (double)0.75, (double)0.5, (double)0.625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.34375, (double)0.125, (double)0.65625, (double)0.46875, (double)0.375, (double)0.71875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.671875, (double)0.125, (double)0.625, (double)0.734375, (double)0.375, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.125, (double)0.25, (double)0.375, (double)0.3125, (double)0.5), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.375, (double)0.25, (double)0.625, (double)0.5625, (double)0.5), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5625, (double)0.125, (double)0.25, (double)0.75, (double)0.3125, (double)0.5), facing, face)});
                MachineAddonBlock.MACHINE_INVENTORY_PROXY_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.875, (double)0.375, (double)0.375, (double)1.0, (double)0.625, (double)0.625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.375, (double)0.375, (double)0.125, (double)0.625, (double)0.625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.375, (double)0.0, (double)0.625, (double)0.625, (double)0.125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.375, (double)0.875, (double)0.625, (double)0.625, (double)1.0), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.8125, (double)0.375, (double)0.625, (double)1.0, (double)0.625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.00125, (double)0.3125, (double)1.0, (double)0.93875, (double)0.375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.00125, (double)0.625, (double)1.0, (double)0.93875, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.3125, (double)6.25E-4, (double)0.0, (double)0.375, (double)0.938125, (double)1.0), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.625, (double)6.25E-4, (double)0.0, (double)0.6875, (double)0.938125, (double)1.0), facing, face)});
                MachineAddonBlock.QUARRY_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.375, (double)0.25, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.625, (double)0.125, (double)0.3125, (double)0.6875, (double)0.1875, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.125, (double)0.25, (double)0.875, (double)0.1875, (double)0.4375), facing, face)});
                MachineAddonBlock.MACHINE_HUNTER_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.375, (double)0.25, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5, (double)0.1875, (double)0.4375, (double)0.75, (double)0.25, (double)0.5625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.125, (double)0.375, (double)0.8125, (double)0.1875, (double)0.625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5625, (double)0.1875, (double)0.375, (double)0.6875, (double)0.25, (double)0.4375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5, (double)0.125, (double)0.3125, (double)0.75, (double)0.1875, (double)0.375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5, (double)0.125, (double)0.625, (double)0.75, (double)0.1875, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5625, (double)0.1875, (double)0.5625, (double)0.6875, (double)0.25, (double)0.625), facing, face)});
                MachineAddonBlock.MACHINE_REDSTONE_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.125, (double)0.0, (double)0.4375, (double)0.25, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.0, (double)0.0015625, (double)0.6875, (double)0.1875, (double)0.0640625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.625, (double)0.125, (double)0.1875, (double)0.75, (double)0.25, (double)0.3125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.625, (double)0.125, (double)0.5, (double)0.75, (double)0.25, (double)0.625), facing, face)});
                MachineAddonBlock.MACHINE_SPEED_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.125, (double)0.75), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.125, (double)0.625, (double)0.875, (double)0.25, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.125, (double)0.125, (double)0.375, (double)0.25, (double)0.75), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.125, (double)0.25, (double)0.25, (double)0.25, (double)0.375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.125, (double)0.5, (double)0.25, (double)0.25, (double)0.625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.625, (double)0.125, (double)0.75, (double)0.75, (double)0.25, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.125, (double)0.75, (double)0.5, (double)0.25, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.125, (double)0.1875, (double)0.8125, (double)0.1875, (double)0.625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.5, (double)0.1875, (double)0.3125, (double)0.6875, (double)0.625, (double)0.5), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.1875, (double)0.375, (double)0.75, (double)0.5625, (double)0.4375), facing, face)});
                MachineAddonBlock.STEAM_BOILER_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.875), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.125, (double)0.3125, (double)0.25, (double)0.25, (double)0.4375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.75, (double)0.125, (double)0.3125, (double)0.875, (double)0.25, (double)0.4375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.125, (double)0.5625, (double)0.5625, (double)0.25, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)6.25E-5, (double)0.25, (double)0.3125, (double)1.000125, (double)0.625, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.1875, (double)0.375, (double)1.0, (double)0.6875, (double)0.625), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)1.25E-4, (double)0.3125, (double)0.25, (double)1.00025, (double)0.5625, (double)0.75), facing, face)});
                MachineAddonBlock.MACHINE_YIELD_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.25, (double)0.375, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.75, (double)0.125, (double)0.125, (double)0.875, (double)0.375, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.125, (double)0.125, (double)0.75, (double)0.375, (double)0.25), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.3125, (double)0.125, (double)0.3125, (double)0.6875, (double)0.25, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.125, (double)0.5625, (double)0.3125, (double)0.4375, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.6875, (double)0.125, (double)0.5625, (double)0.9375, (double)0.4375, (double)0.6875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.125, (double)0.3125, (double)0.3125, (double)0.4375, (double)0.4375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.6875, (double)0.125, (double)0.3125, (double)0.9375, (double)0.4375, (double)0.4375), facing, face)});
                MachineAddonBlock.MACHINE_SILK_TOUCH_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), facing, face), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.375, (double)0.25, (double)0.875), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.625, (double)0.1875, (double)0.3125, (double)0.6875, (double)0.25, (double)0.8125), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.1875, (double)0.25, (double)0.875, (double)0.25, (double)0.4375), facing, face), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.125, (double)0.1875, (double)0.875, (double)0.1875, (double)0.875), facing, face)});
            }
        }
    }

    public record AddonSettings(boolean extender, float speedMultiplier, float efficiencyMultiplier, long addedCapacity, long addedInsert, boolean acceptEnergy, boolean needsSupport, int chamberCount, VoxelShape[][] boundingShape) {
        public static AddonSettings getDefaultSettings() {
            return new AddonSettings(false, 1.0f, 1.0f, 0L, 0L, false, true, 0, null);
        }

        public AddonSettings withExtender(boolean newExtender) {
            return new AddonSettings(newExtender, this.speedMultiplier, this.efficiencyMultiplier, this.addedCapacity, this.addedInsert, this.acceptEnergy, this.needsSupport, this.chamberCount, this.boundingShape);
        }

        public AddonSettings withSpeedMultiplier(float newMultiplier) {
            return new AddonSettings(this.extender, newMultiplier, this.efficiencyMultiplier, this.addedCapacity, this.addedInsert, this.acceptEnergy, this.needsSupport, this.chamberCount, this.boundingShape);
        }

        public AddonSettings withEfficiencyMultiplier(float newMultiplier) {
            return new AddonSettings(this.extender, this.speedMultiplier, newMultiplier, this.addedCapacity, this.addedInsert, this.acceptEnergy, this.needsSupport, this.chamberCount, this.boundingShape);
        }

        public AddonSettings withAddedCapacity(long newCapacity) {
            return new AddonSettings(this.extender, this.speedMultiplier, this.efficiencyMultiplier, newCapacity, this.addedInsert, this.acceptEnergy, this.needsSupport, this.chamberCount, this.boundingShape);
        }

        public AddonSettings withAddedInsert(long newInsert) {
            return new AddonSettings(this.extender, this.speedMultiplier, this.efficiencyMultiplier, this.addedCapacity, newInsert, this.acceptEnergy, this.needsSupport, this.chamberCount, this.boundingShape);
        }

        public AddonSettings withAcceptEnergy(boolean newAccept) {
            return new AddonSettings(this.extender, this.speedMultiplier, this.efficiencyMultiplier, this.addedCapacity, this.addedInsert, newAccept, this.needsSupport, this.chamberCount, this.boundingShape);
        }

        public AddonSettings withNeedsSupport(boolean newSupport) {
            return new AddonSettings(this.extender, this.speedMultiplier, this.efficiencyMultiplier, this.addedCapacity, this.addedInsert, this.acceptEnergy, newSupport, this.chamberCount, this.boundingShape);
        }

        public AddonSettings withChambers(int chambers) {
            return new AddonSettings(this.extender, this.speedMultiplier, this.efficiencyMultiplier, this.addedCapacity, this.addedInsert, this.acceptEnergy, this.needsSupport, chambers, this.boundingShape);
        }

        public AddonSettings withBoundingShape(VoxelShape[][] newShape) {
            return new AddonSettings(this.extender, this.speedMultiplier, this.efficiencyMultiplier, this.addedCapacity, this.addedInsert, this.acceptEnergy, this.needsSupport, this.chamberCount, newShape);
        }
    }
}

