/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.jei;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.jei.LootFabCategory;
import dev.shadowsoffire.hostilenetworks.jei.LootFabRecipe;
import dev.shadowsoffire.hostilenetworks.jei.SimChamberCategory;
import dev.shadowsoffire.hostilenetworks.jei.TickingDataModelWrapper;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class HostileJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = HostileNetworks.loc("plugin");

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)Hostile.Items.DATA_MODEL.value(), (ISubtypeInterpreter)new ModelSubtypes());
        reg.registerSubtypeInterpreter((Item)Hostile.Items.PREDICTION.value(), (ISubtypeInterpreter)new ModelSubtypes());
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new SimChamberCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new LootFabCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        SimChamberCategory.recipes = DataModelRegistry.INSTANCE.getValues().stream().map(TickingDataModelWrapper::new).collect(Collectors.toList());
        reg.addRecipes(SimChamberCategory.TYPE, SimChamberCategory.recipes);
        ArrayList<LootFabRecipe> fabRecipes = new ArrayList<LootFabRecipe>();
        for (DataModel dm : DataModelRegistry.INSTANCE.getValues()) {
            for (int i = 0; i < dm.fabDrops().size(); ++i) {
                fabRecipes.add(new LootFabRecipe(dm, i));
            }
        }
        reg.addRecipes(LootFabCategory.TYPE, fabRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Hostile.Blocks.SIM_CHAMBER.value()), new RecipeType[]{SimChamberCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Hostile.Blocks.LOOT_FABRICATOR.value()), new RecipeType[]{LootFabCategory.TYPE});
    }

    public ResourceLocation getPluginUid() {
        return UID;
    }

    private static class ModelSubtypes
    implements ISubtypeInterpreter<ItemStack> {
        private ModelSubtypes() {
        }

        public DynamicHolder<DataModel> getSubtypeData(ItemStack stack, UidContext context) {
            return DataModelItem.getStoredModel(stack);
        }

        public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext context) {
            DynamicHolder<DataModel> dm = DataModelItem.getStoredModel(stack);
            if (!dm.isBound()) {
                return "NULL";
            }
            return dm.getId().toString();
        }
    }
}

