/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.client;

import dev.shadowsoffire.hostilenetworks.client.DeepLearnerHudRenderer;
import dev.shadowsoffire.hostilenetworks.data.DataModelInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public record DataModelTooltipRenderer(DataModelInstance model) implements ClientTooltipComponent
{
    public int getHeight() {
        return 29;
    }

    public int getWidth(Font font) {
        Component tierName = this.model.getTier().getComponent();
        return Math.max(107, font.width((FormattedText)tierName) + font.width(I18n.get((String)"hostilenetworks.hud.model", (Object[])new Object[0])));
    }

    public void renderImage(Font font, int x, int y, GuiGraphics gfx) {
        gfx.renderItem(this.model.getSourceStack(), x, y + 10);
        gfx.pose().pushPose();
        gfx.pose().translate(0.0f, 0.0f, 0.0f);
        gfx.blit(DeepLearnerHudRenderer.DL_HUD, x + 20, y + 12, 0.0f, 0.0f, 89, 12, 256, 256);
        int width = 87;
        if (!this.model.getTier().isMax()) {
            int prev = this.model.getTierData();
            width = Mth.ceil((float)((float)(width * (this.model.getData() - prev)) / (float)(this.model.getNextTierData() - prev)));
        }
        gfx.blit(DeepLearnerHudRenderer.DL_HUD, x + 21, y + 13, 0.0f, 12.0f, width, 10, 256, 256);
        gfx.pose().popPose();
    }

    public void renderText(Font font, int x, int y, Matrix4f srcMatrix, MultiBufferSource.BufferSource bufferSource) {
        Component tierName = this.model.getTier().getComponent();
        Matrix4f mat = new Matrix4f((Matrix4fc)srcMatrix);
        mat.translate(0.0f, 0.0f, 0.05f);
        font.drawInBatch(tierName, (float)x, (float)y, -1, true, mat, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch((Component)Component.translatable((String)"hostilenetworks.hud.model").withStyle(tierName.getStyle()), (float)(x + font.width((FormattedText)tierName)), (float)y, -1, true, mat, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (!this.model.getTier().isMax()) {
            font.drawInBatch(I18n.get((String)"hostilenetworks.hud.kills", (Object[])new Object[]{this.model.getKillsNeeded()}), (float)(x + 23), (float)(y + 14), -1, true, mat, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }
}

