/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mss.world.structures;

import com.finndog.mss.modinit.MSSStructures;
import com.finndog.mss.utils.GeneralUtils;
import com.finndog.mss.world.structures.GenericJigsawStructure;
import com.finndog.mss.world.structures.codecs.YRangeAllowance;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class GenericNetherJigsawStructure
extends GenericJigsawStructure {
    public static final MapCodec<GenericNetherJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GenericNetherJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)YRangeAllowance.CODEC.optionalFieldOf("y_allowance").forGetter(structure -> structure.yAllowance), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.CODEC.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)100).optionalFieldOf("ledge_offset_y").forGetter(structure -> structure.ledgeOffsetY), (App)StringRepresentable.fromEnum(LAND_SEARCH_DIRECTION::values).fieldOf("land_search_direction").forGetter(structure -> structure.searchDirection), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, GenericNetherJigsawStructure::new));
    public final Optional<Integer> ledgeOffsetY;
    public final LAND_SEARCH_DIRECTION searchDirection;

    public GenericNetherJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<YRangeAllowance> yAllowance, HeightProvider startHeight, boolean cannotSpawnInLiquid, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<Integer> ledgeOffsetY, LAND_SEARCH_DIRECTION searchDirection, boolean useBoundingBoxHack, LiquidSettings liquidSettings) {
        super(config, startPool, size, yAllowance, startHeight, Optional.empty(), cannotSpawnInLiquid, Optional.empty(), Optional.empty(), biomeRadius, poolsThatIgnoreBoundaries, maxDistanceFromCenter, Optional.empty(), useBoundingBoxHack, liquidSettings);
        this.ledgeOffsetY = ledgeOffsetY;
        this.searchDirection = searchDirection;
    }

    @Override
    protected void postLayoutAdjustments(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context, int offsetY, BlockPos blockpos, int topClipOff, int bottomClipOff, List<PoolElementStructurePiece> pieces) {
        GeneralUtils.centerAllPieces(blockpos, pieces);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        BlockPos placementPos = this.searchDirection == LAND_SEARCH_DIRECTION.HIGHEST_LAND ? GeneralUtils.getHighestLand(context.chunkGenerator(), context.randomState(), structurePiecesBuilder.getBoundingBox(), context.heightAccessor(), !this.cannotSpawnInLiquid) : GeneralUtils.getLowestLand(context.chunkGenerator(), context.randomState(), structurePiecesBuilder.getBoundingBox(), context.heightAccessor(), !this.cannotSpawnInLiquid);
        if (placementPos.getY() >= GeneralUtils.getMaxTerrainLimit(context.chunkGenerator()) || placementPos.getY() <= context.chunkGenerator().getSeaLevel() + 1) {
            int yDiff = context.chunkGenerator().getSeaLevel() + this.ledgeOffsetY.orElse(0) - pieces.get(0).getBoundingBox().minY();
            pieces.forEach(piece -> piece.move(0, yDiff, 0));
        } else {
            int yDiff = placementPos.getY() + this.ledgeOffsetY.orElse(0) - pieces.get(0).getBoundingBox().minY();
            pieces.forEach(piece -> piece.move(0, yDiff, 0));
        }
        pieces.forEach(piece -> piece.move(0, offsetY, 0));
    }

    @Override
    public StructureType<?> type() {
        return MSSStructures.GENERIC_NETHER_JIGSAW_STRUCTURE.get();
    }

    public static enum LAND_SEARCH_DIRECTION implements StringRepresentable
    {
        HIGHEST_LAND("HIGHEST_LAND"),
        LOWEST_LAND("LOWEST_LAND");

        private final String name;
        private static final Map<String, LAND_SEARCH_DIRECTION> BY_NAME;

        private LAND_SEARCH_DIRECTION(String name) {
            this.name = name;
        }

        public static LAND_SEARCH_DIRECTION byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.make((Object)Maps.newHashMap(), hashMap -> {
                LAND_SEARCH_DIRECTION[] var1;
                for (LAND_SEARCH_DIRECTION type : var1 = LAND_SEARCH_DIRECTION.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

