/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.storage;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class DimTankStorage
extends AbstractDimStorage
implements IFluidHandler {
    public static final int CAPACITY = 16000;
    private Tank tank = new Tank(16000);

    public DimTankStorage(DimStorageManager manager, Frequency freq) {
        super(manager, freq);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluid().copy();
    }

    public int getTankCapacity(int tank) {
        return 16000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    @Override
    public void clearStorage() {
        this.tank = new Tank(16000);
        this.setDirty();
    }

    @Override
    public String type() {
        return "fluid";
    }

    @Override
    public CompoundTag saveToTag(HolderLookup.Provider registries) {
        CompoundTag compound = new CompoundTag();
        compound.put("tank", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
        return compound;
    }

    @Override
    public void loadFromTag(HolderLookup.Provider registries, CompoundTag tag) {
        this.tank.readFromNBT(registries, tag.getCompound("tank"));
    }

    private class Tank
    extends FluidTank {
        public Tank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            DimTankStorage.this.setDirty();
        }
    }
}

