/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.block;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.MapCodec;
import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.common.block.MetronomeBe;
import earth.terrarium.tempad.common.block.MetronomeBlock;
import earth.terrarium.tempad.common.data.MetronomeData;
import earth.terrarium.tempad.common.registries.ModAttachmentsKt;
import earth.terrarium.tempad.common.registries.ModBlocks;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import earth.terrarium.tempad.common.utils.ItemStackBuilderKt;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\n\b\u0000\u0010\u0006*\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\rH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J0\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0014J\u0012\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010#H\u0014J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006'"}, d2={"Learth/terrarium/tempad/common/block/MetronomeBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "<init>", "()V", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "onRemove", "", "pos", "Lnet/minecraft/core/BlockPos;", "newState", "movedByPiston", "", "onPlace", "oldState", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getDrops", "", "Lnet/minecraft/world/item/ItemStack;", "params", "Lnet/minecraft/world/level/storage/loot/LootParams$Builder;", "codec", "Lcom/mojang/serialization/MapCodec;", "newBlockEntity", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMetronomeBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetronomeBlock.kt\nearth/terrarium/tempad/common/block/MetronomeBlock\n+ 2 Extensions.kt\nearth/terrarium/tempad/common/utils/ExtensionsKt\n*L\n1#1,116:1\n212#2:117\n212#2:118\n212#2:119\n*S KotlinDebug\n*F\n+ 1 MetronomeBlock.kt\nearth/terrarium/tempad/common/block/MetronomeBlock\n*L\n54#1:117\n70#1:118\n85#1:119\n*E\n"})
public final class MetronomeBlock
extends BaseEntityBlock {
    public MetronomeBlock() {
        super(BlockBehaviour.Properties.of().strength(3.0f, 1200.0f));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        return BaseEntityBlock.createTickerHelper(blockEntityType, ModBlocks.INSTANCE.getMetronomeBe(), (BlockEntityTicker)getTicker.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MetronomeBe && !level.isClientSide && ((MetronomeBe)blockEntity).getBootTime() == 0) {
            void p1$iv;
            MetronomeData metronomeData = ModAttachmentsKt.getMetronomeEnergy();
            GameProfile gameProfile = ((MetronomeBe)blockEntity).getOwner();
            UUID p2$iv = gameProfile != null ? gameProfile.getId() : null;
            boolean $i$f$safeLet = false;
            if (p1$iv != null && p2$iv != null) {
                void owner;
                UUID uUID = p2$iv;
                void energy = p1$iv;
                boolean bl = false;
                ((MetronomeBe)blockEntity).setInitialChronons(energy.remove((UUID)owner, new GlobalPos(level.dimension(), pos)));
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    /*
     * WARNING - void declaration
     */
    protected void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MetronomeBe && ((MetronomeBe)blockEntity).getBootTime() == 0 && !level.isClientSide) {
            void p1$iv;
            MetronomeData metronomeData = ModAttachmentsKt.getMetronomeEnergy();
            GameProfile gameProfile = ((MetronomeBe)blockEntity).getOwner();
            UUID p2$iv = gameProfile != null ? gameProfile.getId() : null;
            boolean $i$f$safeLet = false;
            if (p1$iv != null && p2$iv != null) {
                void owner;
                UUID uUID = p2$iv;
                void energy = p1$iv;
                boolean bl = false;
                energy.add((UUID)owner, new GlobalPos(level.dimension(), pos), ((MetronomeBe)blockEntity).getInitialChronons());
                ((MetronomeBe)blockEntity).setInitialChronons(0);
            }
        }
        super.onPlace(state, level, pos, oldState, movedByPiston);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        void p1$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        blockEntity = blockEntity instanceof MetronomeBe ? (MetronomeBe)blockEntity : null;
        ServerPlayer p2$iv = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        boolean $i$f$safeLet = false;
        if (p1$iv != null && p2$iv != null) {
            ServerPlayer serverPlayer = p2$iv;
            void blockEntity2 = p1$iv;
            boolean bl = false;
            if (blockEntity2.getBootTime() == 0) {
                void opener;
                if (blockEntity2.getOwner() == null) {
                    blockEntity2.setOwner(player.getGameProfile());
                } else if (blockEntity2.getLocked()) {
                    GameProfile gameProfile = blockEntity2.getOwner();
                    if (!Intrinsics.areEqual((Object)(gameProfile != null ? gameProfile.getId() : null), (Object)player.getGameProfile().getId())) {
                        Object[] objectArray = new Object[]{this.getName()};
                        player.displayClientMessage((Component)Component.translatable((String)"error.tempad.block_locked", (Object[])objectArray).withColor(Tempad.Companion.getORANGE().getValue()), true);
                        return InteractionResult.FAIL;
                    }
                }
                blockEntity2.openMenu((ServerPlayer)opener);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder params) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Object[] objectArray = new ItemStack[]{ItemStackBuilderKt.stack$default(ModItems.INSTANCE.getMetronome(), 0, arg_0 -> MetronomeBlock.getDrops$lambda$4(params, arg_0), 1, null)};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(MetronomeBlock::codec$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        return mapCodec;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new MetronomeBe(pos, state);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    private static final Unit getDrops$lambda$4(LootParams.Builder $params, ItemStack $this$stack) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$stack, (String)"$this$stack");
            Object object = $params.getParameter(LootContextParams.BLOCK_ENTITY);
            MetronomeBe metronomeBe = object instanceof MetronomeBe ? (MetronomeBe)((Object)object) : null;
            if (metronomeBe == null) break block0;
            MetronomeBe it = metronomeBe;
            boolean bl = false;
            ModComponentsKt.setChrononContent((MutableDataComponentHolder)$this$stack, it.getInitialChronons());
        }
        return Unit.INSTANCE;
    }

    private static final MetronomeBlock codec$lambda$5(BlockBehaviour.Properties it) {
        return new MetronomeBlock();
    }
}

