/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gen;

import com.mojang.serialization.Codec;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityAuraBloom;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class LevelGenAuraBloom
extends Feature<NoneFeatureConfiguration> {
    private final Block block;
    private final int chance;
    private final boolean nether;

    public LevelGenAuraBloom(Block block, int chance, boolean nether) {
        super(Codec.unit((Object)FeatureConfiguration.NONE));
        this.block = block;
        this.chance = chance;
        this.nether = nether;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel levelIn = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource rand = ctx.random();
        if (rand.nextInt(this.chance) != 0) {
            return false;
        }
        int startX = pos.getX() + rand.nextInt(16);
        int startZ = pos.getZ() + rand.nextInt(16);
        boolean any = false;
        block0: for (int i = Mth.nextInt((RandomSource)rand, (int)3, (int)8); i > 0; --i) {
            int offX = startX + Mth.nextInt((RandomSource)rand, (int)-5, (int)5);
            int offZ = startZ + Mth.nextInt((RandomSource)rand, (int)-5, (int)5);
            if (this.nether) {
                int y = Mth.nextInt((RandomSource)rand, (int)0, (int)128);
                for (int off = 0; off < 64; ++off) {
                    if (!this.tryPlace(levelIn, new BlockPos(offX, y - off, offZ)) && !this.tryPlace(levelIn, new BlockPos(offX, y + off, offZ))) continue;
                    any = true;
                    continue block0;
                }
                continue;
            }
            BlockPos placePos = new BlockPos(offX, levelIn.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, offX, offZ), offZ);
            if (!this.tryPlace(levelIn, placePos)) continue;
            any = true;
        }
        return any;
    }

    private boolean tryPlace(WorldGenLevel level, BlockPos pos) {
        BlockState state = this.block.defaultBlockState();
        if (state.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, state, 3);
            BlockEntity tile = level.getBlockEntity(pos);
            if (tile instanceof BlockEntityAuraBloom) {
                BlockEntityAuraBloom bloom = (BlockEntityAuraBloom)tile;
                bloom.justGenerated = true;
            }
            return true;
        }
        return false;
    }
}

