/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.naturesaura.entities.EntityEffectInhibitor;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderEffectInhibitor
extends EntityRenderer<EntityEffectInhibitor> {
    private final Map<ResourceLocation, ItemStack> items = new HashMap<ResourceLocation, ItemStack>();

    public RenderEffectInhibitor(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public ResourceLocation getTextureLocation(EntityEffectInhibitor entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    public void render(EntityEffectInhibitor entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        float time = (float)(entity.renderTicks + entity.getId()) + partialTicks;
        float bob = (float)Math.sin(time / 10.0f) * 0.05f;
        matrixStackIn.translate(0.0f, 0.15f + bob, 0.0f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(time * 3.0f % 360.0f));
        ResourceLocation effect = entity.getInhibitedEffect();
        ItemStack stack = this.items.computeIfAbsent(effect, res -> ItemEffectPowder.setEffect(new ItemStack((ItemLike)ModItems.EFFECT_POWDER), effect));
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, packedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, entity.level(), 0);
        matrixStackIn.popPose();
    }
}

