/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.events.ClientEvents;
import de.ellpeck.naturesaura.renderers.SupporterFancyHandler;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import vazkii.patchouli.api.BookDrawScreenEvent;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.PatchouliAPI;

public class PatchouliCompat
implements ICompat {
    public static final ResourceLocation BOOK = ResourceLocation.fromNamespaceAndPath((String)"naturesaura", (String)"book");
    private static final Map<ResourceLocation, IMultiblock> MULTIBLOCKS = new HashMap<ResourceLocation, IMultiblock>();

    public static void addPatchouliMultiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        for (int i = 1; i < rawMatchers.length; i += 2) {
            Object object = rawMatchers[i];
            if (!(object instanceof Matcher)) continue;
            Matcher matcher = (Matcher)object;
            Matcher.ICheck check = matcher.check();
            rawMatchers[i] = check == null ? PatchouliAPI.get().anyMatcher() : PatchouliAPI.get().predicateMatcher(matcher.defaultState(), state -> check.matches(null, null, null, null, (BlockState)state, '\u0000'));
        }
        MULTIBLOCKS.put(name, PatchouliAPI.get().makeMultiblock(pattern, rawMatchers));
    }

    public static <T extends Recipe<?>> T getRecipe(String type, String name) {
        ResourceLocation res;
        ResourceLocation pre;
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        RecipeHolder holder = manager.byKey(pre = ResourceLocation.fromNamespaceAndPath((String)(res = ResourceLocation.parse((String)name)).getNamespace(), (String)(type + "/" + res.getPath()))).orElse(null);
        return (T)(holder != null ? holder.value() : null);
    }

    public static IVariable ingredientVariable(Ingredient ingredient, HolderLookup.Provider registries) {
        return IVariable.wrapList((Iterable)Arrays.stream(ingredient.getItems()).map(i -> IVariable.from((Object)i, (HolderLookup.Provider)registries)).collect(Collectors.toList()), (HolderLookup.Provider)registries);
    }

    @Override
    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (Map.Entry<ResourceLocation, IMultiblock> entry : MULTIBLOCKS.entrySet()) {
                PatchouliAPI.get().registerMultiblock(entry.getKey(), entry.getValue());
            }
            PatchouliAPI.get().setConfigFlag("naturesaura:rf_converter", ((Boolean)ModConfig.instance.rfConverter.get()).booleanValue());
            PatchouliAPI.get().setConfigFlag("naturesaura:chunk_loader", ((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue());
        });
    }

    @Override
    public void setupClient() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onBookDraw(BookDrawScreenEvent event) {
        ResourceLocation book = event.getBook();
        Screen gui = event.getScreen();
        if (book == null || !book.equals((Object)BOOK)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.MAY && now.getDayOfMonth() == 21) {
            x = gui.width / 2 + 136 - 16;
            y = gui.height / 2 - 90 - 26;
            event.getGraphics().blit(ClientEvents.BOOK_GUI, x, y, 469.0f, 0.0f, 43, 42, 512, 256);
            if (event.getMouseX() >= x && event.getMouseY() >= y && event.getMouseX() < x + 43 && event.getMouseY() < y + 42) {
                event.getGraphics().renderTooltip(Minecraft.getInstance().font, Collections.singletonList(Component.literal((String)"It's the author Ellpeck's birthday!").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GOLD))), Optional.empty(), event.getMouseX(), event.getMouseY());
            }
        } else if (now.getMonth() == Month.JUNE) {
            x = gui.width / 2 + 136;
            y = gui.height / 2 + 32;
            event.getGraphics().blit(ClientEvents.BOOK_GUI, x, y, 424.0f, 0.0f, 45, 26, 512, 256);
            if (event.getMouseX() >= x && event.getMouseY() >= y && event.getMouseX() < x + 45 && event.getMouseY() < y + 26) {
                event.getGraphics().renderTooltip(gui.getMinecraft().font, Collections.singletonList(Component.literal((String)"\u00a76Happy \u00a74P\u00a76r\u00a7ei\u00a72d\u00a79e\u00a75!")), Optional.empty(), event.getMouseX(), event.getMouseY());
            }
        }
        String name = gui.getMinecraft().player.getName().getString();
        SupporterFancyHandler.FancyInfo info = SupporterFancyHandler.FANCY_INFOS.get(name);
        if (info != null) {
            int x = gui.width / 2 - 136 + 20;
            int y = gui.height / 2 + 90;
            event.getGraphics().blit(ClientEvents.BOOK_GUI, x, y, 496.0f, 44.0f, 16, 18, 512, 256);
            if (info.tier() == 1) {
                event.getGraphics().blit(ClientEvents.BOOK_GUI, x, y, 480.0f, 44.0f, 16, 18, 512, 256);
            } else {
                float r = (float)(info.color() >> 16 & 0xFF) / 255.0f;
                float g = (float)(info.color() >> 8 & 0xFF) / 255.0f;
                float b = (float)(info.color() & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
                event.getGraphics().blit(ClientEvents.BOOK_GUI, x, y, 464.0f, 44.0f, 16, 18, 512, 256);
            }
            if (event.getMouseX() >= x && event.getMouseY() >= y && event.getMouseX() < x + 16 && event.getMouseY() < y + 18) {
                event.getGraphics().renderTooltip(gui.getMinecraft().font, Collections.singletonList(Component.literal((String)("Thanks for your support, " + name + "!")).setStyle(Style.EMPTY.applyFormat(ChatFormatting.YELLOW))), Optional.empty(), event.getMouseX(), event.getMouseY());
            }
        }
    }
}

