/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.tool.BaseSwordItem;
import com.blakebr0.mysticalagriculture.api.soul.ISoulSiphoningItem;
import com.blakebr0.mysticalagriculture.lib.ModItemTier;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class SouliumDaggerItem
extends BaseSwordItem
implements ISoulSiphoningItem {
    private final DaggerType type;

    public SouliumDaggerItem(Tier tier, DaggerType type) {
        super(tier, type.getDamage(), -2.4f, p -> p.durability(type.getDurability()));
        this.type = type;
    }

    public String getDescriptionId(ItemStack stack) {
        return "item.mysticalagriculture.soulium_dagger";
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        switch (this.type.ordinal()) {
            case 1: {
                tooltip.add((Component)ModTooltips.PASSIVE_ATTUNED.color(ChatFormatting.GREEN).build());
                tooltip.add((Component)ModTooltips.PASSIVE_SOULIUM_DAGGER.build());
                break;
            }
            case 2: {
                tooltip.add((Component)ModTooltips.HOSTILE_ATTUNED.color(ChatFormatting.RED).build());
                tooltip.add((Component)ModTooltips.HOSTILE_SOULIUM_DAGGER.build());
                break;
            }
            case 3: {
                tooltip.add((Component)ModTooltips.CREATIVE_ATTUNED.color(ChatFormatting.LIGHT_PURPLE).build());
                tooltip.add((Component)ModTooltips.CREATIVE_SOULIUM_DAGGER.build());
            }
        }
    }

    @Override
    public double getSiphonAmount(ItemStack stack, LivingEntity entity) {
        return this.type.getSiphonAmount(stack, entity);
    }

    public static enum DaggerType {
        BASIC(3, ModItemTier.SOULIUM.getUses(), (stack, entity) -> 1.0),
        PASSIVE(6, ModItemTier.SOULIUM.getUses() * 2, (stack, entity) -> DaggerType.isPassive(entity) ? 1.5 : 1.0),
        HOSTILE(6, ModItemTier.SOULIUM.getUses() * 2, (stack, entity) -> !DaggerType.isPassive(entity) ? 1.5 : 1.0),
        CREATIVE(65, -1, (stack, entity) -> Double.MAX_VALUE);

        private final int damage;
        private final int durability;
        private final BiFunction<ItemStack, LivingEntity, Double> siphonAmountFunc;

        private DaggerType(int damage, int durability, BiFunction<ItemStack, LivingEntity, Double> siphonAmountFunc) {
            this.damage = damage;
            this.durability = durability;
            this.siphonAmountFunc = siphonAmountFunc;
        }

        public double getSiphonAmount(ItemStack stack, LivingEntity entity) {
            return this.siphonAmountFunc.apply(stack, entity);
        }

        public int getDamage() {
            return this.damage;
        }

        public int getDurability() {
            return this.durability;
        }

        private static boolean isPassive(LivingEntity entity) {
            return entity.getClassification(false).isFriendly();
        }
    }
}

