/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.mysticalagriculture.api.util.ExperienceCapsuleUtils;
import com.blakebr0.mysticalagriculture.init.ModDataComponentTypes;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ExperienceCapsuleItem
extends BaseItem {
    public ExperienceCapsuleItem() {
        super(p -> p.stacksTo(1).component(ModDataComponentTypes.EXPERIENCE_CAPSULE, (Object)0));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int experience = ExperienceCapsuleUtils.getExperience(stack);
        if (player.isCrouching()) {
            if (experience > 0) {
                int xpToGive = Math.min(experience, ExperienceCapsuleItem.getExperienceToGive(player));
                xpToGive -= ExperienceCapsuleUtils.removeExperienceFromCapsule(stack, xpToGive);
                ExperienceCapsuleItem.giveExperiencePoints(player, xpToGive);
                return InteractionResultHolder.success((Object)stack);
            }
        } else if (experience < 1200 && player.totalExperience > 0) {
            int xpToTake = Math.min(1200 - experience, ExperienceCapsuleItem.getExperienceToTake(player));
            xpToTake -= ExperienceCapsuleUtils.addExperienceToCapsule(stack, xpToTake);
            ExperienceCapsuleItem.giveExperiencePoints(player, -xpToTake);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        int experience = ExperienceCapsuleUtils.getExperience(stack);
        tooltip.add((Component)ModTooltips.EXPERIENCE_CAPSULE.args(new Object[]{Formatting.number((Object)experience), Formatting.number((Object)1200)}).build());
    }

    public static ItemPropertyFunction getFillPropertyGetter() {
        return (stack, _level, _entity, _unused) -> {
            int experience = ExperienceCapsuleUtils.getExperience(stack);
            if (experience > 0) {
                double level = (double)experience / 1200.0;
                return (int)(level * 10.0);
            }
            return 0.0f;
        };
    }

    private static int getExperienceToGive(Player player) {
        int xpNeeded = player.getXpNeededForNextLevel();
        int extraXp = Math.round((float)xpNeeded * player.experienceProgress);
        return xpNeeded - extraXp;
    }

    private static int getExperienceToTake(Player player) {
        float progress = (float)Math.round(player.experienceProgress * 10.0f) / 10.0f;
        if (progress > 0.0f) {
            int xpNeeded = player.getXpNeededForNextLevel();
            return Math.round((float)xpNeeded * player.experienceProgress);
        }
        --player.experienceLevel;
        int xpNeeded = player.getXpNeededForNextLevel();
        ++player.experienceLevel;
        return xpNeeded;
    }

    private static void giveExperiencePoints(Player player, int points) {
        player.experienceProgress += (float)points / (float)player.getXpNeededForNextLevel();
        player.totalExperience = Mth.clamp((int)(player.totalExperience + points), (int)0, (int)Integer.MAX_VALUE);
        while (player.experienceProgress < 0.0f) {
            float f = player.experienceProgress * (float)player.getXpNeededForNextLevel();
            if (player.experienceLevel > 0) {
                ExperienceCapsuleItem.giveExperienceLevels(player, -1);
                player.experienceProgress = 1.0f + f / (float)player.getXpNeededForNextLevel();
                continue;
            }
            ExperienceCapsuleItem.giveExperienceLevels(player, -1);
            player.experienceProgress = 0.0f;
        }
        while (player.experienceProgress >= 1.0f) {
            player.experienceProgress = (player.experienceProgress - 1.0f) * (float)player.getXpNeededForNextLevel();
            ExperienceCapsuleItem.giveExperienceLevels(player, 1);
            player.experienceProgress /= (float)player.getXpNeededForNextLevel();
        }
    }

    private static void giveExperienceLevels(Player player, int levels) {
        player.experienceLevel += levels;
        if (player.experienceLevel < 0) {
            player.experienceLevel = 0;
            player.experienceProgress = 0.0f;
            player.totalExperience = 0;
        }
    }
}

