/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.mysticalagriculture.api.util.ExperienceCapsuleUtils;
import com.blakebr0.mysticalagriculture.item.ExperienceCapsuleItem;
import com.blakebr0.mysticalagriculture.network.payloads.ExperienceCapsulePickupPayload;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public final class ExperienceCapsuleHandler {
    @SubscribeEvent
    public void onPlayerPickupXp(PlayerXpEvent.PickupXp event) {
        ExperienceOrb orb = event.getOrb();
        Player player = event.getEntity();
        List<ItemStack> capsules = ExperienceCapsuleHandler.getExperienceCapsules(player);
        if (!capsules.isEmpty()) {
            for (ItemStack stack : capsules) {
                int remaining;
                orb.value = remaining = ExperienceCapsuleUtils.addExperienceToCapsule(stack, orb.getValue());
                if (remaining != 0) continue;
                orb.discard();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ExperienceCapsulePickupPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                event.setCanceled(true);
                return;
            }
        }
    }

    private static List<ItemStack> getExperienceCapsules(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack stack = player.getOffhandItem();
        if (stack.getItem() instanceof ExperienceCapsuleItem) {
            items.add(stack);
        }
        player.getInventory().items.stream().filter(s -> s.getItem() instanceof ExperienceCapsuleItem).forEach(items::add);
        return items;
    }
}

