/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.generator;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelJsonGenerator
extends ItemModelProvider {
    public ItemModelJsonGenerator(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
        ModelFile.UncheckedModelFile generatedModel = new ModelFile.UncheckedModelFile("item/generated");
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            if (crop.shouldRegisterEssenceItem()) {
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(crop.getNameWithSuffix("essence"))).parent((ModelFile)generatedModel)).texture("layer0", crop.getTextures().getEssenceTexture());
            }
            if (!crop.shouldRegisterSeedsItem()) continue;
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(crop.getNameWithSuffix("seeds"))).parent((ModelFile)generatedModel)).texture("layer0", crop.getTextures().getSeedTexture());
        }
        ModelFile.UncheckedModelFile augmentModel = new ModelFile.UncheckedModelFile(MysticalAgriculture.resource("item/augment"));
        for (Augment augment : AugmentRegistry.getInstance().getAugments()) {
            ((ItemModelBuilder)this.getBuilder(augment.getNameWithSuffix("augment"))).parent((ModelFile)augmentModel);
        }
    }

    public String getName() {
        return "Mystical Agriculture item model generator";
    }
}

