/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.technici4n.moderndynamics.ModernDynamics;
import dev.technici4n.moderndynamics.util.FluidVariantImpl;
import dev.technici4n.moderndynamics.util.TransferVariant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface FluidVariant
extends TransferVariant<Fluid> {
    public static final Codec<FluidVariant> CODEC = ExtraCodecs.optionalEmptyMap((Codec)FluidStack.fixedAmountCodec((int)1).xmap(FluidVariant::of, fv -> fv.toStack(1))).xmap(o -> o.orElse(FluidVariant.blank()), fv -> fv.isBlank() ? Optional.empty() : Optional.of(fv));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidVariant> STREAM_CODEC = FluidStack.STREAM_CODEC.map(FluidVariant::of, fv -> fv.toStack(1));

    public static FluidVariant blank() {
        return FluidVariant.of(Fluids.EMPTY);
    }

    public static FluidVariant of(FluidStack stack) {
        return FluidVariantImpl.of(stack);
    }

    public static FluidVariant of(Fluid fluid) {
        return FluidVariantImpl.of(fluid);
    }

    public boolean matches(FluidStack var1);

    default public Fluid getFluid() {
        return (Fluid)this.getObject();
    }

    public FluidStack toStack(int var1);

    @Override
    default public Tag toNbt(HolderLookup.Provider registries) {
        return (Tag)CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public static FluidVariant fromNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        return CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)ModernDynamics.LOGGER).error(arg_0)).orElse(FluidVariant.blank());
    }

    @Override
    default public void toPacket(RegistryFriendlyByteBuf buf) {
        STREAM_CODEC.encode((Object)buf, (Object)this);
    }

    public static FluidVariant fromPacket(RegistryFriendlyByteBuf buf) {
        return (FluidVariant)STREAM_CODEC.decode((Object)buf);
    }

    default public List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.toStack(1).getHoverName());
        String modId = BuiltInRegistries.FLUID.getKey((Object)this.getFluid()).getNamespace();
        String modName = FluidVariant.formatModName(modId);
        if (tooltip.isEmpty() || !((Component)tooltip.get(tooltip.size() - 1)).getString().equals(modName)) {
            tooltip.add((Component)Component.literal((String)modName));
        }
        return tooltip;
    }

    private static String formatModName(String modId) {
        return String.valueOf(ChatFormatting.BLUE) + String.valueOf(ChatFormatting.ITALIC) + FluidVariant.getModName(modId);
    }

    private static String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(mc -> mc.getModInfo().getDisplayName()).orElse(modId);
    }
}

