/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.test;

import dev.technici4n.moderndynamics.test.FluidTransferTest;
import dev.technici4n.moderndynamics.test.ItemDistributionTest;
import dev.technici4n.moderndynamics.test.ItemTransferTest;
import dev.technici4n.moderndynamics.test.MdGameTest;
import dev.technici4n.moderndynamics.test.framework.MdGameTestHelper;
import dev.technici4n.moderndynamics.util.MdId;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.neoforged.neoforge.gametest.GameTestHolder;

@GameTestHolder
public class MdGameTests {
    private final List<Class<?>> testClasses = List.of(FluidTransferTest.class, ItemDistributionTest.class, ItemTransferTest.class);

    @GameTestGenerator
    public List<TestFunction> generateTests() {
        ArrayList<TestFunction> result = new ArrayList<TestFunction>();
        for (Class<?> testClass : this.testClasses) {
            for (Method testMethod : testClass.getMethods()) {
                MdGameTest gametest = testMethod.getDeclaredAnnotation(MdGameTest.class);
                if (gametest == null) continue;
                result.add(new TestFunction(gametest.batch(), "moderndynamics." + testMethod.getName().toLowerCase(), MdId.of("empty").toString(), StructureUtils.getRotationForRotationSteps((int)gametest.rotationSteps()), gametest.timeoutTicks(), gametest.setupTicks(), gametest.required(), gametest.manualOnly(), gametest.attempts(), gametest.requiredSuccesses(), gametest.skyAccess(), gameTestHelper -> {
                    try {
                        Object testObject = testClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        testMethod.invoke(testObject, new Object[]{new MdGameTestHelper(gameTestHelper.testInfo)});
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
        }
        return result;
    }
}

