/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.fluid;

import com.google.common.primitives.Ints;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.fluid.ConnectedFluidStorage;
import dev.technici4n.moderndynamics.network.fluid.FluidHost;
import dev.technici4n.moderndynamics.util.FluidVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidCache
extends NetworkCache<FluidHost, FluidCache> {
    private FluidCacheStorage fluidStorage = null;
    private int attractorBuffer = 0;
    private boolean allowNetworkIo = true;

    protected FluidCache(ServerLevel level, List<NetworkNode<FluidHost, FluidCache>> networkNodes) {
        super(level, networkNodes);
    }

    public FluidCacheStorage getOrCreateStorage() {
        this.combine();
        return this.fluidStorage;
    }

    @Override
    protected void doCombine() {
        FluidVariant fv = FluidVariant.blank();
        int amount = 0;
        for (NetworkNode node : this.nodes) {
            FluidHost host = (FluidHost)node.getHost();
            if (host.getVariant().isBlank()) continue;
            if (fv.isBlank()) {
                fv = host.getVariant();
            }
            amount += host.getAmount();
        }
        this.fluidStorage = new FluidCacheStorage();
        this.fluidStorage.variant = fv;
        this.fluidStorage.amount = amount;
    }

    @Override
    protected void doSeparate() {
        this.nodes.sort(Comparator.comparingLong(node -> 1000L));
        int remainingNodes = this.nodes.size();
        for (NetworkNode node2 : this.nodes) {
            FluidHost host = (FluidHost)node2.getHost();
            int nodeAmount = Math.min(1000, this.fluidStorage.amount / remainingNodes);
            host.setContents(this.fluidStorage.variant, nodeAmount);
            this.fluidStorage.amount -= nodeAmount;
            --remainingNodes;
        }
        this.fluidStorage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTick() {
        this.combine();
        ArrayList<ConnectedFluidStorage> targets = new ArrayList<ConnectedFluidStorage>();
        for (Object node : this.nodes) {
            if (!((FluidHost)((NetworkNode)node).getHost()).isTicking()) continue;
            ((FluidHost)((NetworkNode)node).getHost()).gatherCapabilities(targets);
        }
        ArrayList<FluidAttachedIo> attractors = new ArrayList<FluidAttachedIo>();
        for (ConnectedFluidStorage conn : targets) {
            if (conn.attachment() == null || conn.attachment().getType() != IoAttachmentType.ATTRACTOR) continue;
            attractors.add(conn.attachment());
        }
        boolean changedVariant = false;
        this.allowNetworkIo = false;
        try {
            FluidVariant newVariant;
            if (this.fluidStorage.isResourceBlank() && !(newVariant = this.findVariantForNetwork(targets, attractors)).isBlank() && this.canChangeVariant()) {
                this.fluidStorage.variant = newVariant;
                changedVariant = true;
            }
            if (!this.fluidStorage.isResourceBlank()) {
                this.extractFluid(targets);
                this.attractFluid(targets, attractors);
                this.distributeFluid(targets);
                if (this.fluidStorage.amount == 0 && this.canChangeVariant()) {
                    this.fluidStorage.variant = FluidVariant.blank();
                    changedVariant = true;
                }
            }
        }
        finally {
            this.allowNetworkIo = true;
        }
        if (changedVariant) {
            this.separate();
        }
        this.separate();
    }

    private boolean canChangeVariant() {
        for (NetworkNode node : this.nodes) {
            if (((FluidHost)node.getHost()).isTicking()) continue;
            return false;
        }
        return true;
    }

    private FluidVariant findVariantForNetwork(List<ConnectedFluidStorage> targets, List<FluidAttachedIo> attractors) {
        for (ConnectedFluidStorage t : targets) {
            FluidVariant toExtract;
            if (t.attachment() == null || t.attachment().getType() != IoAttachmentType.EXTRACTOR || (toExtract = this.findExtractableResource(t.storage(), fv -> t.attachment().matchesFilter((FluidVariant)fv))) == null) continue;
            return toExtract;
        }
        if (!attractors.isEmpty()) {
            Predicate<FluidVariant> attractorFilter = fv -> {
                for (FluidAttachedIo a : attractors) {
                    if (!a.matchesFilter((FluidVariant)fv)) continue;
                    return true;
                }
                return false;
            };
            for (ConnectedFluidStorage t : targets) {
                FluidVariant toExtract = this.findExtractableResource(t.storage(), attractorFilter);
                if (toExtract.isBlank()) continue;
                return toExtract;
            }
        }
        return FluidVariant.blank();
    }

    private void extractFluid(List<ConnectedFluidStorage> targets) {
        this.fluidStorage.amount += FluidCache.transferForTargets(FluidCache::drain, targets, this.fluidStorage.variant, this.fluidStorage.getCapacity() - this.fluidStorage.amount, ConnectedFluidStorage::extractorFilteredStorage);
    }

    private void attractFluid(List<ConnectedFluidStorage> targets, List<FluidAttachedIo> attractors) {
        int attractorPower = 0;
        for (FluidAttachedIo attractor : attractors) {
            attractorPower += attractor.matchesFilter(this.fluidStorage.variant) ? attractor.getFluidMaxIo() : 0;
        }
        int maxAttract = this.attractorBuffer + attractorPower;
        int attracted = FluidCache.transferForTargets(FluidCache::drain, targets, this.fluidStorage.variant, Math.min(this.fluidStorage.getCapacity() - this.fluidStorage.amount, maxAttract), ConnectedFluidStorage::storage);
        this.attractorBuffer = Math.min(maxAttract - attracted, 1000);
        this.fluidStorage.amount += attracted;
    }

    private void distributeFluid(List<ConnectedFluidStorage> targets) {
        this.fluidStorage.amount -= FluidCache.transferForTargets(FluidCache::fill, targets, this.fluidStorage.variant, this.fluidStorage.amount, ConnectedFluidStorage.filterAttractors(true));
        this.fluidStorage.amount -= FluidCache.transferForTargets(FluidCache::fill, targets, this.fluidStorage.variant, this.fluidStorage.amount, ConnectedFluidStorage.filterAttractors(false));
    }

    /*
     * WARNING - void declaration
     */
    private static int transferForTargets(TransferOperation operation, List<ConnectedFluidStorage> targets, FluidVariant variant, int maxAmount, Function<ConnectedFluidStorage, IFluidHandler> storageGetter) {
        void var8_13;
        if (maxAmount == 0) {
            return 0;
        }
        int intMaxAmount = Ints.saturatedCast((long)maxAmount);
        ArrayList<FluidTarget> sortableTargets = new ArrayList<FluidTarget>(targets.size());
        for (ConnectedFluidStorage connectedFluidStorage : targets) {
            IFluidHandler storage = storageGetter.apply(connectedFluidStorage);
            if (storage == null) continue;
            sortableTargets.add(new FluidTarget(storage));
        }
        Collections.shuffle(sortableTargets);
        for (FluidTarget fluidTarget : sortableTargets) {
            fluidTarget.simulationResult = operation.transfer(fluidTarget.target, variant, intMaxAmount, IFluidHandler.FluidAction.SIMULATE);
        }
        sortableTargets.sort(Comparator.comparingLong(t -> t.simulationResult));
        int transferredAmount = 0;
        boolean bl = false;
        while (var8_13 < sortableTargets.size()) {
            FluidTarget target = (FluidTarget)sortableTargets.get((int)var8_13);
            int remainingTargets = sortableTargets.size() - var8_13;
            long remainingAmount = maxAmount - transferredAmount;
            int targetMaxAmount = Ints.saturatedCast((long)(remainingAmount / (long)remainingTargets));
            transferredAmount += operation.transfer(target.target, variant, targetMaxAmount, IFluidHandler.FluidAction.EXECUTE);
            ++var8_13;
        }
        return transferredAmount;
    }

    @Override
    public void appendDebugInfo(StringBuilder out) {
        super.appendDebugInfo(out);
        if (this.fluidStorage == null) {
            out.append("no item storage\n");
        } else {
            out.append("item variant = ").append(this.fluidStorage.variant).append("\n");
            out.append("amount = ").append(this.fluidStorage.amount).append("\n");
            out.append("capacity = ").append(this.fluidStorage.getCapacity()).append("\n");
        }
    }

    static boolean areCompatible(FluidVariant v1, FluidVariant v2) {
        return v1.isBlank() || v2.isBlank() || v1.equals(v2);
    }

    private FluidVariant findExtractableResource(IFluidHandler storage, Predicate<FluidVariant> filter) {
        for (int i = 0; i < storage.getTanks(); ++i) {
            FluidStack fluidInTank = storage.getFluidInTank(i);
            FluidVariant variant = FluidVariant.of(fluidInTank);
            if (!filter.test(variant) || storage.drain(fluidInTank, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
            return variant;
        }
        return FluidVariant.blank();
    }

    private static int drain(IFluidHandler handler, FluidVariant variant, int maxAmount, IFluidHandler.FluidAction action) {
        FluidStack stack = variant.toStack(maxAmount);
        FluidStack result = handler.drain(stack, action);
        return result.getAmount();
    }

    private static int fill(IFluidHandler handler, FluidVariant variant, int maxAmount, IFluidHandler.FluidAction action) {
        return handler.fill(variant.toStack(maxAmount), action);
    }

    public class FluidCacheStorage
    implements IFluidHandler {
        private FluidVariant variant = FluidVariant.blank();
        private int amount;

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? this.variant.toStack(this.amount) : FluidStack.EMPTY;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            if (tank == 0) {
                return this.variant.matches(stack) || this.variant.isBlank() && FluidCache.this.canChangeVariant();
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int insertedAmount;
            if (resource.isEmpty()) {
                return 0;
            }
            if (!FluidCache.this.allowNetworkIo) {
                return 0;
            }
            if (this.isFluidValid(0, resource) && (insertedAmount = Math.min(resource.getAmount(), this.getCapacity() - this.amount)) > 0) {
                if (action.execute()) {
                    if (this.variant.isBlank()) {
                        this.variant = FluidVariant.of(resource);
                        this.amount = insertedAmount;
                    } else {
                        this.amount += insertedAmount;
                    }
                    this.update();
                }
                return insertedAmount;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!FluidCache.this.allowNetworkIo) {
                return FluidStack.EMPTY;
            }
            int extractedAmount = Math.min(maxDrain, this.amount);
            if (extractedAmount > 0) {
                FluidStack result = this.variant.toStack(extractedAmount);
                if (action.execute()) {
                    this.amount -= extractedAmount;
                    if (this.amount == 0 && FluidCache.this.canChangeVariant()) {
                        this.variant = FluidVariant.blank();
                    }
                    this.update();
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        private void update() {
            FluidVariant oldVariant = ((FluidHost)((NetworkNode)FluidCache.this.nodes.get(0)).getHost()).getVariant();
            if (!Objects.equals(oldVariant, this.variant)) {
                FluidCache.this.separate();
            }
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!FluidCache.this.allowNetworkIo || resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (this.variant.matches(resource)) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public boolean isResourceBlank() {
            return this.variant.isBlank();
        }

        public FluidVariant getResource() {
            return this.variant;
        }

        public int getAmount() {
            return this.amount;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? this.getCapacity() : 0;
        }

        public int getCapacity() {
            return FluidCache.this.nodes.size() * 1000;
        }
    }

    static interface TransferOperation {
        public int transfer(IFluidHandler var1, FluidVariant var2, int var3, IFluidHandler.FluidAction var4);
    }

    private static class FluidTarget {
        final IFluidHandler target;
        long simulationResult;

        FluidTarget(IFluidHandler target) {
            this.target = target;
        }
    }
}

