/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.compat.jade;

import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItem;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.ItemVariant;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum ItemPipeServerProvider implements IServerExtensionProvider<ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return MdId.of("item_pipe");
    }

    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
        Object object = accessor.getTarget();
        if (!(object instanceof PipeBlockEntity)) {
            return null;
        }
        PipeBlockEntity pipe = (PipeBlockEntity)((Object)object);
        ItemHost itemHost = pipe.findHost(ItemHost.class);
        if (itemHost == null) {
            return null;
        }
        ArrayList<ViewGroup<ItemStack>> groups = new ArrayList<ViewGroup<ItemStack>>();
        for (Direction side : Direction.values()) {
            ItemAttachedIo io;
            AttachedAttachment attachedAttachment = pipe.getAttachment(side);
            if (!(attachedAttachment instanceof ItemAttachedIo) || !(io = (ItemAttachedIo)attachedAttachment).isStuffed()) continue;
            ViewGroup group = new ViewGroup(new ArrayList());
            group.views.addAll(ItemPipeServerProvider.variantMapToStacks(io.getStuffedItems()));
            group.id = "stuffed_" + side.getName();
            groups.add((ViewGroup<ItemStack>)group);
        }
        ViewGroup dummyGroup = new ViewGroup(new ArrayList());
        dummyGroup.views.add(MdItems.WRENCH.getDefaultInstance());
        dummyGroup.id = "dummy";
        groups.add(dummyGroup);
        return groups;
    }

    private static Collection<ItemStack> variantMapToStacks(Map<ItemVariant, Integer> map) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Map.Entry<ItemVariant, Integer> entry : map.entrySet()) {
            stacks.add(entry.getKey().toStack(entry.getValue()));
        }
        stacks.sort(Comparator.comparingInt(ItemStack::getCount).reversed());
        return stacks;
    }

    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> serverGroups) {
        Item attachmentItem;
        Object object = accessor.getTarget();
        if (!(object instanceof PipeBlockEntity)) {
            return List.of();
        }
        PipeBlockEntity pipe = (PipeBlockEntity)((Object)object);
        ArrayList<ClientViewGroup<ItemView>> clientGroups = new ArrayList<ClientViewGroup<ItemView>>();
        Vec3 posInBlock = pipe.getPosInBlock(accessor.getHitResult());
        Direction hitAttachmentSide = pipe.hitTestAttachments(posInBlock);
        if (hitAttachmentSide != null && (attachmentItem = pipe.getAttachmentItem(hitAttachmentSide)) != null) {
            serverGroups.stream().filter(vg -> vg.id != null && vg.id.equals("stuffed_" + hitAttachmentSide.getName())).findFirst().ifPresent(group -> {
                ClientViewGroup clientGroup = new ClientViewGroup(new ArrayList());
                for (ItemStack stack : group.views) {
                    clientGroup.views.add(new ItemView(stack));
                }
                clientGroup.title = Component.translatable((String)"gui.moderndynamics.tooltip.stuffed", (Object[])new Object[]{attachmentItem.getDescription()}).withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true)));
                clientGroups.add(clientGroup);
            });
        }
        if (!clientGroups.isEmpty()) {
            return clientGroups;
        }
        for (NodeHost host : pipe.getHosts()) {
            if (!(host instanceof ItemHost)) continue;
            ItemHost itemHost = (ItemHost)host;
            HashMap<ItemVariant, Integer> items = new HashMap<ItemVariant, Integer>();
            for (ClientTravelingItem item : itemHost.getClientTravelingItems()) {
                items.merge(item.variant(), item.amount(), Integer::sum);
            }
            ClientViewGroup clientGroup = new ClientViewGroup(new ArrayList());
            for (ItemStack stack : ItemPipeServerProvider.variantMapToStacks(items)) {
                clientGroup.views.add(new ItemView(stack));
            }
            if (clientGroup.views.isEmpty()) continue;
            clientGroups.add((ClientViewGroup<ItemView>)clientGroup);
        }
        return clientGroups;
    }
}

