/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.screen;

import dev.technici4n.moderndynamics.attachment.Setting;
import dev.technici4n.moderndynamics.attachment.settings.FilterNbtMode;
import dev.technici4n.moderndynamics.attachment.settings.OversendingMode;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.client.screen.AttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.CycleSettingButton;
import dev.technici4n.moderndynamics.client.screen.PlusMinusButton;
import dev.technici4n.moderndynamics.gui.menu.ItemAttachedIoMenu;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class ItemAttachedIoScreen
extends AttachedIoScreen<ItemAttachedIoMenu> {
    @Nullable
    private Rect2i maxItemsInInventoryTooltipRect;
    @Nullable
    private Rect2i maxItemsExtractedTooltipRect;
    private PlusMinusButton decMaxItemsInInventory;
    private PlusMinusButton incMaxItemsInInventory;
    private PlusMinusButton decMaxItemsExtracted;
    private PlusMinusButton incMaxItemsExtracted;
    private CycleSettingButton<FilterNbtMode> filterNbtModeButton;
    private CycleSettingButton<RoutingMode> routingModeButton;
    private CycleSettingButton<OversendingMode> oversendingModeButton;

    public ItemAttachedIoScreen(ItemAttachedIoMenu handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
        this.imageHeight = 204;
        this.inventoryLabelY = this.imageHeight - 93;
    }

    @Override
    protected void init() {
        super.init();
        if (((ItemAttachedIoMenu)this.menu).isSettingSupported(Setting.MAX_ITEMS_IN_INVENTORY)) {
            this.decMaxItemsInInventory = new PlusMinusButton(this.leftPos + 137, this.topPos + 28, true, () -> this.adjustMaxItemsInInventory(-1));
            this.addRenderableWidget((GuiEventListener)this.decMaxItemsInInventory);
            this.incMaxItemsInInventory = new PlusMinusButton(this.leftPos + 153, this.topPos + 28, false, () -> this.adjustMaxItemsInInventory(1));
            this.addRenderableWidget((GuiEventListener)this.incMaxItemsInInventory);
        }
        if (((ItemAttachedIoMenu)this.menu).isSettingSupported(Setting.MAX_ITEMS_EXTRACTED)) {
            this.decMaxItemsExtracted = new PlusMinusButton(this.leftPos + 137, this.topPos + 57, true, () -> this.adjustMaxItemsExtracted(-1));
            this.addRenderableWidget((GuiEventListener)this.decMaxItemsExtracted);
            this.incMaxItemsExtracted = new PlusMinusButton(this.leftPos + 153, this.topPos + 57, false, () -> this.adjustMaxItemsExtracted(1));
            this.addRenderableWidget((GuiEventListener)this.incMaxItemsExtracted);
        }
    }

    @Override
    protected void addToggleButtons(List<CycleSettingButton<?>> toggleButtons) {
        super.addToggleButtons(toggleButtons);
        if (((ItemAttachedIoMenu)this.menu).isSettingSupported(Setting.FILTER_NBT)) {
            this.filterNbtModeButton = new CycleSettingButton<FilterNbtMode>(CycleSettingButton.FILTER_NBT, ((ItemAttachedIoMenu)this.menu).getFilterNbt(), ((ItemAttachedIoMenu)this.menu)::setFilterNbt).requiresAdvancedBehavior();
            toggleButtons.add(this.filterNbtModeButton);
        }
        if (((ItemAttachedIoMenu)this.menu).isSettingSupported(Setting.ROUTING_MODE)) {
            this.routingModeButton = new CycleSettingButton<RoutingMode>(CycleSettingButton.ROUTING_MODE, ((ItemAttachedIoMenu)this.menu).getRoutingMode(), ((ItemAttachedIoMenu)this.menu)::setRoutingMode).requiresAdvancedBehavior();
            toggleButtons.add(this.routingModeButton);
        }
        if (((ItemAttachedIoMenu)this.menu).isSettingSupported(Setting.OVERSENDING_MODE)) {
            this.oversendingModeButton = new CycleSettingButton<OversendingMode>(CycleSettingButton.OVERSENDING_MODE, ((ItemAttachedIoMenu)this.menu).getOversendingMode(), ((ItemAttachedIoMenu)this.menu)::setOversendingMode).requiresAdvancedBehavior();
            toggleButtons.add(this.oversendingModeButton);
        }
    }

    private void adjustMaxItemsInInventory(int i) {
        if (ItemAttachedIoScreen.hasShiftDown()) {
            i *= 16;
        }
        ((ItemAttachedIoMenu)this.menu).setMaxItemsInInventory(((ItemAttachedIoMenu)this.menu).getMaxItemsInInventory() + i, true);
    }

    private void adjustMaxItemsExtracted(int i) {
        if (ItemAttachedIoScreen.hasShiftDown()) {
            i *= 16;
        }
        ((ItemAttachedIoMenu)this.menu).setMaxItemsExtracted(((ItemAttachedIoMenu)this.menu).getMaxItemsExtracted() + i, true);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.decMaxItemsInInventory != null && this.incMaxItemsInInventory != null) {
            this.decMaxItemsInInventory.active = ((ItemAttachedIoMenu)this.menu).getMaxItemsInInventory() > 0;
            boolean bl = this.incMaxItemsInInventory.active = ((ItemAttachedIoMenu)this.menu).getMaxItemsInInventory() < Integer.MAX_VALUE;
        }
        if (this.decMaxItemsExtracted != null && this.incMaxItemsExtracted != null) {
            this.decMaxItemsExtracted.active = ((ItemAttachedIoMenu)this.menu).getMaxItemsExtracted() > 1;
            boolean bl = this.incMaxItemsExtracted.active = ((ItemAttachedIoMenu)this.menu).getMaxItemsExtracted() < ((ItemAttachedIoMenu)this.menu).getMaxItemsExtractedMaximum();
        }
        if (this.filterNbtModeButton != null) {
            this.filterNbtModeButton.active = ((ItemAttachedIoMenu)this.menu).isAdvancedBehaviorAllowed();
            this.filterNbtModeButton.setValue(((ItemAttachedIoMenu)this.menu).getFilterNbt());
        }
        if (this.routingModeButton != null) {
            this.routingModeButton.active = ((ItemAttachedIoMenu)this.menu).isAdvancedBehaviorAllowed();
            this.routingModeButton.setValue(((ItemAttachedIoMenu)this.menu).getRoutingMode());
        }
        if (this.oversendingModeButton != null) {
            this.oversendingModeButton.active = ((ItemAttachedIoMenu)this.menu).isAdvancedBehaviorAllowed();
            this.oversendingModeButton.setValue(((ItemAttachedIoMenu)this.menu).getOversendingMode());
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.maxItemsInInventoryTooltipRect != null && this.maxItemsInInventoryTooltipRect.contains(Math.round(mouseX), Math.round(mouseY))) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.moderndynamics.setting.max_items_in_inventory.tooltip"), mouseX, mouseY);
        } else if (this.maxItemsExtractedTooltipRect != null && this.maxItemsExtractedTooltipRect.contains(Math.round(mouseX), Math.round(mouseY))) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.moderndynamics.setting.max_items_extracted.tooltip"), mouseX, mouseY);
        } else {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, delta, mouseX, mouseY);
        if (((ItemAttachedIoMenu)this.menu).isSettingSupported(Setting.MAX_ITEMS_IN_INVENTORY)) {
            this.renderMaxItemsInInventoryValue(guiGraphics);
        }
        if (((ItemAttachedIoMenu)this.menu).isSettingSupported(Setting.MAX_ITEMS_EXTRACTED)) {
            this.renderMaxItemsExtractedValue(guiGraphics);
        }
    }

    private void renderMaxItemsInInventoryValue(GuiGraphics guiGraphics) {
        Component text = this.getMaxItemsInInventoryText();
        int width = this.font.width((FormattedText)text);
        int n = this.leftPos + 152 - width / 2;
        Objects.requireNonNull(this.font);
        Rect2i rect = new Rect2i(n, this.topPos + 18, width, 9);
        guiGraphics.drawString(this.font, text, rect.getX(), rect.getY(), 0x404040, false);
        this.maxItemsInInventoryTooltipRect = rect;
    }

    private void renderMaxItemsExtractedValue(GuiGraphics guiGraphics) {
        String text = String.valueOf(((ItemAttachedIoMenu)this.menu).getMaxItemsExtracted());
        int width = this.font.width(text);
        int n = this.leftPos + 152 - width / 2;
        Objects.requireNonNull(this.font);
        Rect2i rect = new Rect2i(n, this.topPos + 46, width, 9);
        guiGraphics.drawString(this.font, text, rect.getX(), rect.getY(), 0x404040, false);
        this.maxItemsExtractedTooltipRect = rect;
    }

    private Component getMaxItemsInInventoryText() {
        if (((ItemAttachedIoMenu)this.menu).getMaxItemsInInventory() <= 0) {
            return Component.translatable((String)"gui.moderndynamics.setting.max_items_in_inventory.infinite");
        }
        return Component.literal((String)String.valueOf(((ItemAttachedIoMenu)this.menu).getMaxItemsInInventory()));
    }
}

