/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.model;

import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.client.GeometryHelper;
import dev.technici4n.moderndynamics.model.AttachmentModelData;
import dev.technici4n.moderndynamics.model.PipeModelData;
import dev.technici4n.moderndynamics.thirdparty.fabric.Mesh;
import dev.technici4n.moderndynamics.thirdparty.fabric.MeshBuilderImpl;
import dev.technici4n.moderndynamics.thirdparty.fabric.ModelHelper;
import dev.technici4n.moderndynamics.thirdparty.fabric.QuadEmitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeBakedModel
implements BakedModel {
    private static final ChunkRenderTypeSet CUTOUT_RENDER_TYPES = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
    private final TextureAtlasSprite baseSprite;
    private final Mesh[] baseMeshes;
    private final BakedModel[] connectorModels;
    private final BakedModel[] straightLineModels;
    private final Map<String, BakedModel[]> attachments;
    private final boolean transparent;
    private static final PipeModelData ITEM_DATA = new PipeModelData(12, 12, new AttachedAttachment[6]);
    private static final ModelData ITEM_MODEL_DATA = ModelData.builder().with(PipeModelData.PIPE_DATA, (Object)ITEM_DATA).build();

    public PipeBakedModel(TextureAtlasSprite baseSprite, BakedModel[] connectorModels, BakedModel[] straightLineModels, Map<String, BakedModel[]> attachments, boolean transparent) {
        this.baseSprite = baseSprite;
        this.connectorModels = connectorModels;
        this.straightLineModels = straightLineModels;
        this.attachments = attachments;
        this.transparent = transparent;
        this.baseMeshes = new Mesh[64];
        MeshBuilderImpl meshBuilder = new MeshBuilderImpl();
        for (int connections = 0; connections < this.baseMeshes.length; ++connections) {
            QuadEmitter qe = meshBuilder.getEmitter();
            for (int i = 0; i < 6; ++i) {
                Direction dir = Direction.from3DDataValue((int)i);
                if ((connections & 1 << i) == 0) {
                    this.baseQuad(qe, dir, 0.3125f, 0.3125f, 0.6875f, 0.6875f, 0.3125f);
                }
                if ((connections & 1 << GeometryHelper.FACE_RIGHT[i].getOpposite().get3DDataValue()) > 0) {
                    this.baseQuad(qe, dir, 0.0f, 0.3125f, 0.3125f, 0.6875f, 0.3125f);
                }
                if ((connections & 1 << GeometryHelper.FACE_RIGHT[i].get3DDataValue()) > 0) {
                    this.baseQuad(qe, dir, 0.6875f, 0.3125f, 1.0f, 0.6875f, 0.3125f);
                }
                if ((connections & 1 << GeometryHelper.FACE_UP[i].getOpposite().get3DDataValue()) > 0) {
                    this.baseQuad(qe, dir, 0.3125f, 0.0f, 0.6875f, 0.3125f, 0.3125f);
                }
                if ((connections & 1 << GeometryHelper.FACE_UP[i].get3DDataValue()) <= 0) continue;
                this.baseQuad(qe, dir, 0.3125f, 0.6875f, 0.6875f, 1.0f, 0.3125f);
            }
            this.baseMeshes[connections] = meshBuilder.build();
        }
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.baseSprite;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ModelHelper.MODEL_TRANSFORM_BLOCK;
    }

    private void appendBitmasked(Consumer<BakedModel> consumer, int mask, BakedModel[] models) {
        for (int i = 0; i < 6; ++i) {
            if ((mask & 1 << i) <= 0) continue;
            consumer.accept(models[i]);
        }
    }

    public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pDirection, RandomSource pRandom) {
        return this.getQuads(pState, pDirection, pRandom, ITEM_MODEL_DATA, null);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        PipeModelData pipeData = (PipeModelData)data.get(PipeModelData.PIPE_DATA);
        if (pipeData == null) {
            pipeData = PipeModelData.DEFAULT;
        }
        byte connectionsPipe = pipeData.pipeConnections();
        byte connectionsInventory = pipeData.inventoryConnections();
        int connections = connectionsInventory | connectionsPipe;
        for (int i = 0; i < 6; ++i) {
            AttachmentModelData attachment = pipeData.attachments()[i];
            if (attachment == null) continue;
            connections |= 1 << i;
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        if (connections == 3 || connections == 12 || connections == 48) {
            BakedModel straightModel = connections == 3 ? this.straightLineModels[0] : (connections == 12 ? this.straightLineModels[2] : this.straightLineModels[4]);
            result.addAll(straightModel.getQuads(state, side, rand, data, renderType));
        } else {
            result.addAll(this.baseMeshes[connections].toBakedBlockQuads());
        }
        Consumer<BakedModel> fallbackConsumer = bakedModel -> result.addAll(bakedModel.getQuads(state, side, rand, data, renderType));
        this.appendBitmasked(fallbackConsumer, connectionsInventory, this.connectorModels);
        for (int i = 0; i < 6; ++i) {
            AttachmentModelData attachment = pipeData.attachments()[i];
            if (attachment == null) continue;
            fallbackConsumer.accept(this.attachments.get(attachment.modelId())[i]);
        }
        return result;
    }

    private void baseQuad(QuadEmitter qe, Direction side, float left, float bottom, float right, float top, float depth) {
        qe.square(side, left, bottom, right, top, depth);
        qe.spriteBake(this.baseSprite, 4);
        qe.color(-1, -1, -1, -1);
        qe.emit();
        if (this.transparent) {
            switch (side) {
                case UP: 
                case DOWN: {
                    qe.square(side.getOpposite(), left, 1.0f - top, right, 1.0f - bottom, 1.0f - depth);
                    break;
                }
                default: {
                    qe.square(side.getOpposite(), 1.0f - right, bottom, 1.0f - left, top, 1.0f - depth);
                }
            }
            qe.spriteBake(this.baseSprite, 4);
            qe.color(-1, -1, -1, -1);
            qe.emit();
        }
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return CUTOUT_RENDER_TYPES;
    }
}

