/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.jei;

import dev.technici4n.moderndynamics.client.screen.AttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.FluidAttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.ItemAttachedIoScreen;
import dev.technici4n.moderndynamics.gui.menu.ConfigSlot;
import dev.technici4n.moderndynamics.gui.menu.FluidAttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.FluidConfigSlot;
import dev.technici4n.moderndynamics.gui.menu.ItemAttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.ItemConfigSlot;
import dev.technici4n.moderndynamics.util.FluidVariant;
import dev.technici4n.moderndynamics.util.ItemVariant;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

class GhostIngredientHandler
implements IGhostIngredientHandler<AttachedIoScreen> {
    GhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AttachedIoScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ConfigSlot slot;
        AttachedIoScreen ioScreen;
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (gui instanceof ItemAttachedIoScreen) {
            ioScreen = (ItemAttachedIoScreen)gui;
            if (ingredient.getIngredient() instanceof ItemStack) {
                for (Slot s : ((ItemAttachedIoMenu)ioScreen.getMenu()).slots) {
                    if (!(s instanceof ItemConfigSlot) || !(slot = (ItemConfigSlot)s).isActive()) continue;
                    targets.add(new ItemSlotTarget((ItemConfigSlot)slot, (ItemAttachedIoScreen)ioScreen));
                }
            }
        }
        if (gui instanceof FluidAttachedIoScreen) {
            ioScreen = (FluidAttachedIoScreen)gui;
            if (ingredient.getIngredient() instanceof FluidStack) {
                for (Slot s : ((FluidAttachedIoMenu)ioScreen.getMenu()).slots) {
                    if (!(s instanceof FluidConfigSlot) || !(slot = (FluidConfigSlot)s).isActive()) continue;
                    targets.add(new FluidSlotTarget((FluidConfigSlot)slot, (FluidAttachedIoScreen)ioScreen));
                }
            }
        }
        return targets;
    }

    public void onComplete() {
    }

    private static Rect2i getSlotBounds(Slot slot, AttachedIoScreen<?> screen) {
        return new Rect2i(slot.x + screen.getLeftPos(), slot.y + screen.getTopPos(), 16, 16);
    }

    private static class ItemSlotTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        private final ItemConfigSlot slot;
        private final ItemAttachedIoScreen ioScreen;

        public ItemSlotTarget(ItemConfigSlot slot, ItemAttachedIoScreen ioScreen) {
            this.slot = slot;
            this.ioScreen = ioScreen;
        }

        public Rect2i getArea() {
            return GhostIngredientHandler.getSlotBounds(this.slot, this.ioScreen);
        }

        public void accept(ItemStack ingredient) {
            if (this.slot.isActive()) {
                ItemVariant iv = ItemVariant.of(ingredient);
                ((ItemAttachedIoMenu)this.ioScreen.getMenu()).setFilter(this.slot.getConfigIdx(), iv, true);
            }
        }
    }

    private static class FluidSlotTarget
    implements IGhostIngredientHandler.Target<FluidStack> {
        private final FluidConfigSlot slot;
        private final FluidAttachedIoScreen ioScreen;

        public FluidSlotTarget(FluidConfigSlot slot, FluidAttachedIoScreen ioScreen) {
            this.slot = slot;
            this.ioScreen = ioScreen;
        }

        public Rect2i getArea() {
            return GhostIngredientHandler.getSlotBounds(this.slot, this.ioScreen);
        }

        public void accept(FluidStack ingredient) {
            if (this.slot.isActive()) {
                FluidVariant fv = FluidVariant.of(ingredient);
                ((FluidAttachedIoMenu)this.ioScreen.getMenu()).setFilter(this.slot.getConfigIdx(), fv, true);
            }
        }
    }
}

