/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.technici4n.moderndynamics.attachment.RenderedAttachment;
import dev.technici4n.moderndynamics.client.ber.PipeBlockEntityRenderer;
import dev.technici4n.moderndynamics.client.model.PipeModelLoader;
import dev.technici4n.moderndynamics.client.screen.FluidAttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.ItemAttachedIoScreen;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.init.MdMenus;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItemSmoothing;
import dev.technici4n.moderndynamics.pipe.PipeBlock;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.pipe.PipeBoundingBoxes;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.HashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;

public final class ModernDynamicsClient {
    public ModernDynamicsClient(IEventBus modEvents) {
        modEvents.addListener(ModelEvent.RegisterGeometryLoaders.class, event -> {
            HashMap<String, ResourceLocation> modelMap = new HashMap<String, ResourceLocation>();
            for (String id : RenderedAttachment.getAttachmentIds()) {
                modelMap.put(id, MdId.of("attachment/" + id));
            }
            event.register(PipeModelLoader.ID, (IGeometryLoader)new PipeModelLoader(modelMap));
        });
        modEvents.addListener(EntityRenderersEvent.RegisterRenderers.class, this::registerRenderers);
        modEvents.addListener(RegisterMenuScreensEvent.class, e -> {
            e.register(MdMenus.ITEM_IO, ItemAttachedIoScreen::new);
            e.register(MdMenus.FLUID_IO, FluidAttachedIoScreen::new);
        });
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Pre.class, e -> {
            if (!Minecraft.getInstance().isPaused()) {
                ClientTravelingItemSmoothing.onUnpausedTick();
            }
        });
        NeoForge.EVENT_BUS.addListener(RenderHighlightEvent.Block.class, ModernDynamicsClient::renderPipeAttachmentOutline);
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        for (PipeBlock pipeBlock : MdBlocks.ALL_PIPES) {
            BlockEntityType<PipeBlockEntity> blockEntityType = pipeBlock.getBlockEntityTypeNullable();
            if (blockEntityType == null) continue;
            evt.registerBlockEntityRenderer(blockEntityType, PipeBlockEntityRenderer::new);
        }
    }

    private static void renderPipeAttachmentOutline(RenderHighlightEvent.Block evt) {
        BlockEntity be;
        ClientLevel level = Minecraft.getInstance().level;
        PoseStack poseStack = evt.getPoseStack();
        MultiBufferSource buffers = evt.getMultiBufferSource();
        Camera camera = evt.getCamera();
        if (level == null) {
            return;
        }
        BlockHitResult blockHitResult = evt.getTarget();
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = blockHitResult.getBlockPos();
        BlockState blockState = level.getBlockState(pos);
        if (blockState.getBlock() instanceof PipeBlock && (be = level.getBlockEntity(pos)) instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            Vec3 hitPosInBlock = Minecraft.getInstance().hitResult.getLocation();
            Direction hitSide = pipe.hitTestAttachments(hitPosInBlock = hitPosInBlock.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
            if (hitSide != null) {
                LevelRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)buffers.getBuffer(RenderType.lines()), (VoxelShape)PipeBoundingBoxes.CONNECTOR_SHAPES[hitSide.ordinal()], (double)((double)pos.getX() - camera.getPosition().x), (double)((double)pos.getY() - camera.getPosition().y), (double)((double)pos.getZ() - camera.getPosition().z), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                evt.setCanceled(true);
            }
        }
    }
}

