/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.attached;

import dev.technici4n.moderndynamics.attachment.IoAttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.FluidCachedFilter;
import dev.technici4n.moderndynamics.gui.menu.AttachmentMenuType;
import dev.technici4n.moderndynamics.gui.menu.FluidAttachedIoMenu;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.ExtendedMenuProvider;
import dev.technici4n.moderndynamics.util.FluidVariant;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class FluidAttachedIo
extends AttachedIo {
    private final NonNullList<FluidVariant> filters = NonNullList.withSize((int)15, (Object)FluidVariant.blank());
    @Nullable
    private FluidCachedFilter cachedFilter = null;

    public FluidAttachedIo(IoAttachmentItem item, CompoundTag configData, Runnable setChangedCallback, HolderLookup.Provider registries) {
        super(item, configData, setChangedCallback, registries);
        ListTag filterTags = configData.getList("filters", 10);
        for (int i = 0; i < this.filters.size(); ++i) {
            CompoundTag filterTag = filterTags.getCompound(i);
            if (filterTag.isEmpty()) continue;
            this.filters.set(i, (Object)FluidVariant.fromNbt(filterTag, registries));
        }
    }

    @Override
    public CompoundTag writeConfigTag(CompoundTag configData, HolderLookup.Provider registries) {
        super.writeConfigTag(configData, registries);
        ListTag filterTags = new ListTag();
        for (FluidVariant filter : this.filters) {
            if (filter.isBlank()) {
                filterTags.add((Object)new CompoundTag());
                continue;
            }
            filterTags.add((Object)filter.toNbt(registries));
        }
        configData.put("filters", (Tag)filterTags);
        return configData;
    }

    @Override
    protected void resetCachedFilter() {
        this.cachedFilter = null;
    }

    public FluidVariant getFilter(int idx) {
        return (FluidVariant)this.filters.get(idx);
    }

    public void setFilter(int idx, FluidVariant variant) {
        if (!variant.equals(this.filters.get(idx))) {
            this.filters.set(idx, (Object)variant);
            this.setChangedCallback.run();
            this.resetCachedFilter();
        }
    }

    public boolean matchesFilter(FluidVariant variant) {
        if (this.cachedFilter == null) {
            this.cachedFilter = new FluidCachedFilter(this.filters.subList(0, this.getFilterSize()), this.getFilterInversion());
        }
        return this.cachedFilter.matches(variant);
    }

    public int getFluidMaxIo() {
        return this.upgradeContainer.getFluidMaxIo();
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    @Nullable
    public ExtendedMenuProvider createMenu(final PipeBlockEntity pipe, final Direction side) {
        return new ExtendedMenuProvider(){

            @Override
            public void writeScreenOpeningData(RegistryFriendlyByteBuf buf) {
                AttachmentMenuType.writeScreenOpeningData(pipe, side, FluidAttachedIo.this, buf);
            }

            public Component getDisplayName() {
                return FluidAttachedIo.this.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int syncId, Inventory pPlayerInventory, Player pPlayer) {
                return new FluidAttachedIoMenu(syncId, pPlayerInventory, pipe, side, FluidAttachedIo.this);
            }
        };
    }
}

