/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import tv.soaryn.xycraft.core.container.energy.EnergyContainer;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public final class CommonCodecs {
    public static final Codec<int[]> IntArrayCodec = Codec.INT_STREAM.xmap(IntStream::toArray, Arrays::stream);
    public static final Codec<ChunkPos> ChunkPosCodec = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("x").forGetter(data -> data.x), (App)Codec.INT.fieldOf("z").forGetter(data -> data.z)).apply((Applicative)builder, ChunkPos::new));
    public static final Codec<FluidTank> FluidTankCodec = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.Codecs.FLUID_STACK_OPTIONAL.fieldOf("fluid").forGetter(FluidTank::getFluid), (App)Codec.INT.fieldOf("capacity").forGetter(FluidTank::getCapacity)).apply((Applicative)builder, (fluidStack, capacity) -> {
        FluidTank tank = new FluidTank(capacity.intValue());
        tank.setFluid(fluidStack);
        return tank;
    }));

    public static <T extends IItemContainerHolder> RecordCodecBuilder<T, List<ItemStack>> recordCodec(String key) {
        return CodecUtils.Codecs.ITEM_STACK_OPTIONAL.listOf().fieldOf(key).forGetter(data -> data.getInventory().copyToList());
    }

    public static <TAttachment, TResource extends IResource> RecordCodecBuilder<TAttachment, NonNullList<MutableResourceStack<TResource>>> containerOf(String key, Codec<MutableResourceStack<TResource>> codec, Function<TAttachment, IResourceContainer<TResource>> containerToStackList) {
        return NonNullList.codecOf(codec).fieldOf(key).forGetter(attachment -> ((IResourceContainer)containerToStackList.apply(attachment)).copyToList());
    }

    public static <TAttachment> RecordCodecBuilder<TAttachment, NonNullList<MutableResourceStack<ItemResource>>> itemContainerOf(String key, Function<TAttachment, IResourceContainer<ItemResource>> containerToStackList) {
        return CommonCodecs.containerOf(key, MutableResourceStack.Codecs.OPTIONAL_ITEM_CODEC, containerToStackList);
    }

    public static <TAttachment> RecordCodecBuilder<TAttachment, NonNullList<MutableResourceStack<FluidResource>>> fluidContainerOf(String key, Function<TAttachment, IResourceContainer<FluidResource>> containerToStackList) {
        return CommonCodecs.containerOf(key, MutableResourceStack.Codecs.OPTIONAL_FLUID_CODEC, containerToStackList);
    }

    public static <TAttachment> RecordCodecBuilder<TAttachment, int[]> unitContainerOf(String key, Function<TAttachment, EnergyContainer> containerToStackList) {
        return IntArrayCodec.fieldOf(key).forGetter(attachment -> ((EnergyContainer)containerToStackList.apply(attachment)).copyContents());
    }

    public static interface IItemContainerHolder {
        public ItemContainer getInventory();
    }
}

