/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.rules;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.utils.rules.CoreRules;
import tv.soaryn.xycraft.core.utils.rules.FluidRuleGroup;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.core.utils.rules.IRuleType;

public record FluidTagRule(TagKey<Fluid> tag) implements IRule,
FluidRuleGroup
{
    public static final MapCodec<FluidTagRule> CODEC = TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag").xmap(FluidTagRule::new, FluidTagRule::tag);

    public static FluidTagRule water() {
        return new FluidTagRule((TagKey<Fluid>)FluidTags.WATER);
    }

    public static FluidTagRule lava() {
        return new FluidTagRule((TagKey<Fluid>)FluidTags.LAVA);
    }

    @Override
    public boolean matches(BlockState state) {
        return state.getFluidState().is(this.tag());
    }

    @Override
    @NotNull
    public IRuleType<?> getType() {
        return (IRuleType)CoreRules.RuleFluidTag.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FluidTagRule) {
            FluidTagRule rule = (FluidTagRule)obj;
            return this.tag().equals(rule.tag());
        }
        return false;
    }
}

