/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widgets.drawable;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.widgets.DrawableWidget;
import tv.soaryn.xycraft.core.ui.widgets.MutableRectangle;

public class DrawableFrame
extends DrawableWidget<DrawableFrame> {
    public final MutableRectangle Padding;
    private NineSlicedResource _window;

    protected DrawableFrame() {
        this.Padding = new MutableRectangle(this.Dimensions.x, this.Dimensions.y, this.Dimensions.width, this.Dimensions.height);
        this._window = new NineSlicedResource(XyCore.resource("textures/gui/sliced/border.png"));
    }

    public static DrawableFrame create() {
        return new DrawableFrame();
    }

    @Override
    public DrawableFrame dimensions(float x, float y, float width, float height) {
        super.dimensions(x, y, this._window.getMinWidth(width), this._window.getMinHeight(height));
        this.Padding.x = this._window.Padding.left();
        this.Padding.y = this._window.Padding.top();
        this.Padding.width = -this._window.Padding.right();
        this.Padding.height = -this._window.Padding.bottom();
        return this;
    }

    public DrawableFrame paddingOverride(float x, float y, float width, float height) {
        this.Padding.x = x;
        this.Padding.y = y;
        this.Padding.width = width;
        this.Padding.height = height;
        return this;
    }

    @Override
    public boolean contains(double mouseX, double mouseY) {
        MutableRectangle bounds = new MutableRectangle(this.Dimensions.x + this.Padding.x, this.Dimensions.y + this.Padding.y, this.Dimensions.width + this.Padding.width, this.Dimensions.height + this.Padding.height);
        return bounds.contains((float)mouseX, (float)mouseY);
    }

    public DrawableFrame texture(NineSlicedResource resource) {
        this._window = resource;
        return this;
    }

    @Override
    protected void drawPre(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        Vector3f vec = new Vector3f();
        graphics.pose().last().pose().transformPosition(vec);
        graphics.enableScissor((int)(this.Dimensions.x + this.Padding.x + x + vec.x), (int)(this.Dimensions.y + this.Padding.y + y + vec.y), (int)(this.Dimensions.x + this.Dimensions.width + this.Padding.width + x + vec.x), (int)(this.Dimensions.y + this.Dimensions.height + this.Padding.height + y + vec.y));
        super.drawPre(graphics, x, y, mouseX, mouseY, depth);
    }

    @Override
    public void drawWidget(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        graphics.disableScissor();
        RenderSystem.enableBlend();
        this._window.render(graphics.pose(), x + this.Dimensions.x, y + this.Dimensions.y, this.Dimensions.width, this.Dimensions.height, 1.0f);
    }
}

