/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.joml.Matrix4f;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.TiledIcon;

public class NineSlicedResource {
    private final Rectangle[] slicesNew = new Rectangle[9];
    private final ResourceLocation _resource;
    public final int ImageResolution;
    public final int MinWidth;
    public final int MinHeight;
    public NineSliceInfo Points;
    public NineSliceInfo Padding;

    public NineSlicedResource(ResourceLocation loc) {
        this(loc, 0x40FF00FF);
    }

    public NineSlicedResource(ResourceLocation loc, int colorMask) {
        NativeImage image;
        this._resource = loc;
        Arrays.setAll(this.slicesNew, Rectangle::supplier);
        int res = 16;
        Optional resource = Minecraft.getInstance().getResourceManager().getResource(this._resource);
        if (resource.isEmpty()) {
            this.ImageResolution = 0;
            this.MinWidth = 0;
            this.MinHeight = 0;
            return;
        }
        try {
            image = NativeImage.read((InputStream)((Resource)resource.get()).open());
            this.Points = ((Resource)resource.get()).metadata().getSection((MetadataSectionSerializer)new NineSliceSerializer("nine_slice")).orElse(new NineSliceInfo(0, 0, image.getWidth(), image.getHeight()));
            this.Padding = ((Resource)resource.get()).metadata().getSection((MetadataSectionSerializer)new NineSliceSerializer("padding")).orElse(new NineSliceInfo(0, 0, image.getWidth(), image.getHeight()));
        }
        catch (IOException e) {
            this.ImageResolution = 0;
            this.MinWidth = 0;
            this.MinHeight = 0;
            if (this.Points == null) {
                this.Points = new NineSliceInfo(0, 0, 1, 1);
            }
            if (this.Padding == null) {
                this.Padding = new NineSliceInfo(0, 0, 1, 1);
            }
            return;
        }
        res = image.getWidth();
        int imageHeight = image.getHeight();
        int imageWidth = image.getWidth();
        this.slicesNew[0] = new Rectangle(0.0f, 0.0f, this.Points.left, this.Points.top);
        this.slicesNew[1] = new Rectangle(this.Points.left, 0.0f, this.Points.right - this.Points.left, this.Points.top);
        this.slicesNew[2] = new Rectangle(this.Points.right, 0.0f, imageWidth - this.Points.right, this.Points.top);
        this.slicesNew[3] = new Rectangle(0.0f, this.Points.top, this.Points.left, this.Points.bottom - this.Points.top);
        this.slicesNew[4] = new Rectangle(this.Points.left, this.Points.top, this.Points.right - this.Points.left, this.Points.bottom - this.Points.top);
        this.slicesNew[5] = new Rectangle(this.Points.right, this.Points.top, imageWidth - this.Points.right, this.Points.bottom - this.Points.top);
        this.slicesNew[6] = new Rectangle(0.0f, this.Points.bottom, this.Points.left, imageHeight - this.Points.bottom);
        this.slicesNew[7] = new Rectangle(this.Points.left, this.Points.bottom, this.Points.right - this.Points.left, imageHeight - this.Points.bottom);
        this.slicesNew[8] = new Rectangle(this.Points.right, this.Points.bottom, imageWidth - this.Points.right, imageHeight - this.Points.bottom);
        this.ImageResolution = res;
        this.MinWidth = imageWidth;
        this.MinHeight = imageHeight;
    }

    public Rectangle getSliceComponent(@Range(from=0L, to=8L) int index) {
        return this.slicesNew[index % this.slicesNew.length];
    }

    public float getMinWidth() {
        return this.getMinWidth(0.0f);
    }

    public float getMinWidth(float current) {
        return Math.max(current, (float)this.MinWidth);
    }

    public float getMinHeight() {
        return this.getMinHeight(0.0f);
    }

    public float getMinHeight(float current) {
        return Math.max(current, (float)this.MinHeight);
    }

    public ResourceLocation get_resource() {
        return this._resource;
    }

    public void render(@NotNull PoseStack poseStack, float x, float y, float width, float height, float scale) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this._resource);
        width = Math.max(width - (float)this.MinWidth, 1.0f);
        height = Math.max(height - (float)this.MinHeight, 1.0f);
        poseStack.pushPose();
        poseStack.translate(x, y, 0.0f);
        poseStack.scale(scale, scale, scale);
        Matrix4f lastPose = poseStack.last().pose();
        float[] left = new float[]{0.0f, 0.0f, width, 0.0f, 0.0f, width, 0.0f, 0.0f, width};
        float[] right = new float[]{0.0f, width, width, 0.0f, width, width, 0.0f, width, width};
        float[] top = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, height, height, height};
        float[] bottom = new float[]{0.0f, 0.0f, 0.0f, height, height, height, height, height, height};
        TiledIcon.BlitStream blitStream = TiledIcon.BlitStream.create();
        blitStream.begin();
        for (int i = 0; i < this.slicesNew.length; ++i) {
            blitStream.blit(lastPose, this.slicesNew[i].x() + left[i], this.slicesNew[i].x() + this.slicesNew[i].width() + right[i], this.slicesNew[i].y() + top[i], this.slicesNew[i].y() + this.slicesNew[i].height() + bottom[i], 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        }
        blitStream.draw();
        poseStack.popPose();
    }

    public record NineSliceSerializer(String getMetadataSectionName) implements MetadataSectionSerializer<NineSliceInfo>
    {
        @NotNull
        public NineSliceInfo fromJson(JsonObject json) {
            return new NineSliceInfo(json.get("left").getAsInt(), json.get("right").getAsInt(), json.get("top").getAsInt(), json.get("bottom").getAsInt());
        }
    }

    public record NineSliceInfo(int left, int right, int top, int bottom) {
    }
}

