/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.systems;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.blocks.ICapabilityCleanupBlockEntity;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.LevelSystemBase;

public class JanitorWonderSystem
extends LevelSystemBase<BlockTickSystemLevelAttachment> {
    private LongArraySet _chunkIdsToWipe = new LongArraySet();

    @Override
    public void postTick(LevelTickEvent event, BlockTickSystemLevelAttachment data) {
        ServerLevel level;
        super.postTick(event, data);
        Level level2 = event.getLevel();
        if (!(level2 instanceof ServerLevel) || !(level = (ServerLevel)level2).tickRateManager().runsNormally()) {
            return;
        }
        this._chunkIdsToWipe.clear();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (Long2ObjectMap.Entry entry : data.ChunkMap.long2ObjectEntrySet()) {
            long[] arrayOfPosId;
            long chunkId = entry.getLongKey();
            if (!level.shouldTickBlocksAt(chunkId) || !level.getChunkSource().hasChunk(ChunkPos.getX((long)chunkId), ChunkPos.getZ((long)chunkId))) continue;
            this._chunkIdsToWipe.add(chunkId);
            for (long posId : arrayOfPosId = ((LongArraySet)entry.getValue()).toLongArray()) {
                pos.set(posId);
                BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
                if (!(blockEntity instanceof ICapabilityCleanupBlockEntity)) continue;
                ICapabilityCleanupBlockEntity cleanupTask = (ICapabilityCleanupBlockEntity)blockEntity;
                cleanupTask.handleCleanup(level, data, (BlockPos)pos, level.getBlockState((BlockPos)pos), 0L, EnumSet.allOf(Direction.class));
                level.sendParticles((ParticleOptions)ParticleTypes.ASH, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), -1, 0.0, 0.0, 0.0, 0.0);
            }
            ((LongArraySet)entry.getValue()).clear();
        }
        this._chunkIdsToWipe.forEach(arg_0 -> data.ChunkMap.remove(arg_0));
    }

    public void add(ServerLevel level, BlockPos pos) {
        BlockTickSystemLevelAttachment data = (BlockTickSystemLevelAttachment)this.getData((Level)level);
        long posId = pos.asLong();
        long chunkId = ChunkPos.asLong((BlockPos)pos);
        LongArraySet posMap = (LongArraySet)data.ChunkMap.computeIfAbsent(chunkId, aLong -> new LongArraySet());
        if (posMap.contains(posId)) {
            return;
        }
        posMap.add(posId);
    }

    @Override
    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return CoreAttachments.JanitorData;
    }
}

