/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.items;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;
import tv.soaryn.xycraft.core.utils.Utils;

public class ErroredItem
extends XyItem {
    public ErroredItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isEnabled(@NotNull FeatureFlagSet set) {
        return false;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, ctx, tooltips, flags);
        if (stack.has(CoreItemDataComponents.MissingContentError)) {
            tooltips.add((Component)Component.translatable((String)"The item is unavailable, did you remove a mod?").withColor(-4504508));
            CoreItemDataComponents.ComponentErrorData broke = (CoreItemDataComponents.ComponentErrorData)stack.getOrDefault(CoreItemDataComponents.MissingContentError, (Object)new CoreItemDataComponents.ComponentErrorData("Honestly, have no idea!", "Really Broke"));
            tooltips.add((Component)Component.literal((String)broke.simple()).withColor(-4508877));
            if (Utils.SHIFT_KEY_DOWN.getAsBoolean()) {
                tooltips.add((Component)Component.literal((String)broke.fullError()).withColor(-4508877));
            }
        } else {
            tooltips.add((Component)Component.translatable((String)"\ud83c\udfb5You put this item right back where you found it, or so help me!\ud83c\udfb5").withColor(-4508877));
        }
    }
}

