/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.builder;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.DyeableBlock;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.builder.BlockContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.ColoredBlockContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.ColoredItemContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.FluidContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.ItemContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.TorchBlockContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.fluids.XyFluidType;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.core.content.registries.IRegister;

public final class ContentMap
implements IRegister {
    static final CopyOnWriteArrayList<ContentMap> RegistryList = new CopyOnWriteArrayList();
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    public final String ModId;
    final DeferredRegister.Blocks BlockMap;
    final DeferredRegister.Items ItemMap;
    final DeferredRegister<BlockEntityType<?>> BlockEntityMap;
    final DeferredRegister<CreativeModeTab> TabMap;
    final DeferredRegister<FluidType> FluidTypeMap;
    final DeferredRegister<Fluid> FluidMap;
    DeferredHolder<CreativeModeTab, CreativeModeTab> Tab = null;
    public final ArrayList<BlockContent> ListOfBlocks = new ArrayList();
    public final ArrayList<ItemContent> ListOfItems = new ArrayList();
    public final ArrayList<IContent<?>> MappedContent = new ArrayList();
    Map<Class<?>, List<String>> fieldNameMap;

    public static Block[] getColorableBlocks() {
        return (Block[])RegistryList.stream().flatMap(contentRegistry -> contentRegistry.BlockMap.getEntries().stream().map(Supplier::get).filter(block -> block instanceof IColoredBlock)).toArray(Block[]::new);
    }

    public static Item[] getDyeableItemBlockRoots() {
        return (Item[])RegistryList.stream().flatMap(contentRegistry -> contentRegistry.ItemMap.getEntries().stream().map(Supplier::get).filter(BlockItem.class::isInstance).map(BlockItem.class::cast).filter(blockItem -> {
            boolean bl;
            Block patt0$temp = blockItem.getBlock();
            if (patt0$temp instanceof DyeableBlock) {
                DyeableBlock dyeable = (DyeableBlock)patt0$temp;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        })).toArray(BlockItem[]::new);
    }

    public static XyFluidType[] getFluids() {
        return (XyFluidType[])RegistryList.stream().flatMap(registry -> registry.FluidTypeMap.getEntries().stream().map(Supplier::get).filter(XyFluidType.class::isInstance).map(XyFluidType.class::cast)).toArray(XyFluidType[]::new);
    }

    public static Item[] getColorableItemBlocks() {
        return (Item[])RegistryList.stream().flatMap(contentRegistry -> contentRegistry.ItemMap.getEntries().stream().map(Supplier::get).filter(BlockItem.class::isInstance).map(BlockItem.class::cast).filter(blockItem -> blockItem.getBlock() instanceof IColoredBlock)).toArray(BlockItem[]::new);
    }

    public static Item[] getColorableItems() {
        return (Item[])RegistryList.stream().flatMap(contentRegistry -> contentRegistry.ItemMap.getEntries().stream().map(Supplier::get).filter(IColoredBlock.class::isInstance).map(Item.class::cast)).toArray(Item[]::new);
    }

    private ContentMap(Class<?> c, String modId) {
        this.ModId = modId;
        this.BlockMap = DeferredRegister.createBlocks((String)modId);
        this.ItemMap = DeferredRegister.createItems((String)modId);
        this.BlockEntityMap = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)modId);
        this.FluidTypeMap = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)modId);
        this.FluidMap = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)modId);
        this.TabMap = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)modId);
        this.fieldNameMap = Stream.concat(Arrays.stream(c.getFields()), Arrays.stream(c.getClasses()).map(Class::getFields).flatMap(Arrays::stream)).filter(ContentMap::isContentField).collect(Collectors.groupingBy(Field::getDeclaringClass, Collectors.mapping(Field::getName, Collectors.toList())));
        RegistryList.add(this);
    }

    private static boolean isContentField(Field field) {
        Class<EnumMap> fieldType = field.getType();
        return IContent.class.isAssignableFrom(fieldType) || BlockContent.class.isAssignableFrom(fieldType) || ItemContent.class.isAssignableFrom(fieldType) || fieldType.isAssignableFrom(EnumMap.class) && (((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1].getTypeName().equals(BlockContent.class.getTypeName()) || ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1].getTypeName().equals(ItemContent.class.getTypeName()));
    }

    public ContentMap with(Object ... instances) {
        return this;
    }

    public static ContentMap map(String modId) {
        return new ContentMap(STACK_WALKER.getCallerClass(), modId);
    }

    public ContentMap withTab(DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this.Tab = tab;
        return this;
    }

    public ContentMap withTab(Function<CreativeModeTab.Builder, CreativeModeTab> tabFactory) {
        this.createAndSetTab(tabFactory);
        return this;
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> getTab() {
        return this.Tab;
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> createAndSetTab(Function<CreativeModeTab.Builder, CreativeModeTab> tabFactory) {
        this.Tab = this.createTab("tab", tabFactory);
        return this.Tab;
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> createTab(String title, Function<CreativeModeTab.Builder, CreativeModeTab> tabFactory) {
        return this.TabMap.register("tab_" + this.ModId + "_" + title, () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.%s_%s".formatted(this.ModId, title))).withTabFactory(tabFactory).build());
    }

    String getContentId(Class<?> callingClass) {
        List<String> list = this.fieldNameMap.get(callingClass);
        if (list == null) {
            throw new IllegalStateException("ContentMap tried to access a name for a field in " + callingClass.toString());
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, list.removeFirst());
    }

    public BlockContentRegistrationBuilder block(String name) {
        return (BlockContentRegistrationBuilder)new BlockContentRegistrationBuilder(this, this.getContentId(STACK_WALKER.getCallerClass()), XyBlock::new).inTab(this.Tab).withName(name);
    }

    public BlockContentRegistrationBuilder block(String name, Function<BlockBehaviour.Properties, Block> factory) {
        return (BlockContentRegistrationBuilder)new BlockContentRegistrationBuilder(this, this.getContentId(STACK_WALKER.getCallerClass()), factory).inTab(this.Tab).withName(name);
    }

    public TorchBlockContentRegistrationBuilder torch(String name, BiFunction<BlockBehaviour.Properties, DeferredHolder<ParticleType<?>, ? extends ParticleType<?>>, Block> factory, BiFunction<BlockBehaviour.Properties, DeferredHolder<ParticleType<?>, ? extends ParticleType<?>>, Block> wallFactory) {
        return (TorchBlockContentRegistrationBuilder)new TorchBlockContentRegistrationBuilder(this, this.getContentId(STACK_WALKER.getCallerClass()), factory, wallFactory).withTab(this.Tab).withName(name);
    }

    public <T extends Enum<T> & IColorSource> ColoredBlockContentRegistrationBuilder<T> coloredBlock(String name, Class<T> c) {
        return (ColoredBlockContentRegistrationBuilder)new ColoredBlockContentRegistrationBuilder<Enum>(this, c, this.getContentId(STACK_WALKER.getCallerClass()), (x$0, x$1) -> new ColoredBlock((IColorSource)x$0, (BlockBehaviour.Properties)x$1)).withTab(this.Tab).withName(name);
    }

    public <T extends Enum<T> & IColorSource> ColoredBlockContentRegistrationBuilder<T> coloredBlock(String name, Class<T> c, BiFunction<T, BlockBehaviour.Properties, Block> factory) {
        return (ColoredBlockContentRegistrationBuilder)new ColoredBlockContentRegistrationBuilder<T>(this, c, this.getContentId(STACK_WALKER.getCallerClass()), factory).withTab(this.Tab).withName(name);
    }

    public ItemContentRegistrationBuilder item(String name) {
        return (ItemContentRegistrationBuilder)new ItemContentRegistrationBuilder(this, this.getContentId(STACK_WALKER.getCallerClass()), XyItem::new).inTab(this.Tab).withName(name);
    }

    public ItemContentRegistrationBuilder item(String name, Function<Item.Properties, Item> factory) {
        return (ItemContentRegistrationBuilder)new ItemContentRegistrationBuilder(this, this.getContentId(STACK_WALKER.getCallerClass()), factory).inTab(this.Tab).withName(name);
    }

    public <T extends Enum<T> & IColorSource> ColoredItemContentRegistrationBuilder<T> coloredItem(String name, Class<T> c) {
        return (ColoredItemContentRegistrationBuilder)new ColoredItemContentRegistrationBuilder<Enum>(this, c, this.getContentId(STACK_WALKER.getCallerClass()), (t, properties) -> new XyItem((Item.Properties)properties)).withTab(this.Tab).withName(name);
    }

    public <T extends Enum<T> & IColorSource> ColoredItemContentRegistrationBuilder<T> coloredItem(String name, Class<T> c, BiFunction<T, Item.Properties, Item> factory) {
        return (ColoredItemContentRegistrationBuilder)new ColoredItemContentRegistrationBuilder<T>(this, c, this.getContentId(STACK_WALKER.getCallerClass()), factory).withTab(this.Tab).withName(name);
    }

    public FluidContentRegistrationBuilder fluid() {
        return FluidContentRegistrationBuilder.begin(STACK_WALKER.getCallerClass(), this, XyFluidType::new);
    }

    public FluidContentRegistrationBuilder fluid(String name) {
        return (FluidContentRegistrationBuilder)FluidContentRegistrationBuilder.begin(STACK_WALKER.getCallerClass(), this, XyFluidType::new).withName(name);
    }

    public FluidContentRegistrationBuilder fluid(Function<FluidType.Properties, XyFluidType> factory) {
        return FluidContentRegistrationBuilder.begin(STACK_WALKER.getCallerClass(), this, factory);
    }

    public FluidContentRegistrationBuilder fluid(String name, Function<FluidType.Properties, XyFluidType> factory) {
        return (FluidContentRegistrationBuilder)FluidContentRegistrationBuilder.begin(STACK_WALKER.getCallerClass(), this, factory).withName(name);
    }

    @Override
    public void register(IEventBus bus) {
        this.BlockMap.register(bus);
        this.ItemMap.register(bus);
        this.BlockEntityMap.register(bus);
        this.FluidTypeMap.register(bus);
        this.FluidMap.register(bus);
        this.TabMap.register(bus);
    }
}

