/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.accessors;

import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import tv.soaryn.xycraft.core.content.attachments.TickDataAttachment;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.Utils;

@EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME)
public interface Ticks {
    private static void increment(IAttachmentHolder holder) {
        TickDataAttachment data = (TickDataAttachment)holder.getData(CoreAttachments.Tick);
        ++data.Tick;
        holder.setData(CoreAttachments.Tick, (Object)data);
    }

    public static long toSeconds(long ticks) {
        return ticks * 20L;
    }

    public static long of(IAttachmentHolder holder) {
        TickDataAttachment data = (TickDataAttachment)holder.getData(CoreAttachments.Tick);
        return data.Tick;
    }

    public static void set(IAttachmentHolder holder, long value) {
        TickDataAttachment data = (TickDataAttachment)holder.getData(CoreAttachments.Tick);
        data.Tick = value;
        holder.setData(CoreAttachments.Tick, (Object)data);
    }

    public static long ofClient() {
        TickDataAttachment data = (TickDataAttachment)Utils.getClientLevel().getData(CoreAttachments.Tick);
        return data.Tick;
    }

    public static float smoothClient() {
        TickDataAttachment data = (TickDataAttachment)Utils.getClientLevel().getData(CoreAttachments.Tick);
        return data.PartialSum;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void tick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level.isClientSide() || !level.tickRateManager().runsNormally()) {
            return;
        }
        Ticks.set((IAttachmentHolder)level, level.getGameTime());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void tick(PlayerTickEvent.Pre event) {
        Ticks.increment((IAttachmentHolder)event.getEntity());
    }
}

