/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.serialization.CommonCodecs;

public class InventoryAttachment
implements CommonCodecs.IItemContainerHolder {
    private static final Codec<InventoryAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group(CommonCodecs.recordCodec("inventory")).apply((Applicative)builder, InventoryAttachment::new));
    public final ItemContainer Inventory;
    public final IItemHandler Handler;
    private BlockEntity _blockEntity;

    public static AttachmentType.Builder<InventoryAttachment> builder(int count) {
        return AttachmentUtils.createBuilder(holder -> new InventoryAttachment((BlockEntity)holder, count), CODEC, InventoryAttachment::setAttachmentHolder);
    }

    private InventoryAttachment(List<ItemStack> items) {
        this.Inventory = new SimpleItemContainer(items.size(), this::setChanged);
        this.Handler = this.Inventory.asHandler();
        for (int i = 0; i < items.size(); ++i) {
            this.Inventory.set(i, items.get(i));
        }
    }

    private InventoryAttachment(BlockEntity holder, int count) {
        this.Inventory = new SimpleItemContainer(count, this::setChanged);
        this.Handler = this.Inventory.asHandler();
        this._blockEntity = holder;
    }

    public void setAttachmentHolder(IAttachmentHolder holder) {
        if (holder instanceof BlockEntity) {
            BlockEntity entity;
            this._blockEntity = entity = (BlockEntity)holder;
        }
    }

    private void setChanged() {
        if (this._blockEntity != null) {
            this._blockEntity.setChanged();
        }
    }

    @Override
    public ItemContainer getInventory() {
        return this.Inventory;
    }
}

