/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import tv.soaryn.xycraft.core.container.RecordEnergyContainer;
import tv.soaryn.xycraft.core.container.RecordFluidContainer;
import tv.soaryn.xycraft.core.container.SimpleResourceItemContainer;
import tv.soaryn.xycraft.core.container.energy.EnergyContainer;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandler;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.protocontainer.TransferAction;
import tv.soaryn.xycraft.core.utils.protocontainer.energy.IEnergyHandler;
import tv.soaryn.xycraft.core.utils.serialization.CommonCodecs;

public class ContainerAttachmentTest {
    public static final Codec<ContainerAttachmentTest> CODEC = RecordCodecBuilder.create(builder -> builder.group(CommonCodecs.itemContainerOf("item_resources", ContainerAttachmentTest::getItemContainer), CommonCodecs.fluidContainerOf("fluid_resources", ContainerAttachmentTest::getFluidContainer), (App)Codec.INT.fieldOf("tank_capacity").forGetter(ContainerAttachmentTest::getTankCapacity), CommonCodecs.unitContainerOf("energy_values", ContainerAttachmentTest::getEnergyContainer), CommonCodecs.unitContainerOf("mana_values", ContainerAttachmentTest::getManaContainer)).apply((Applicative)builder, ContainerAttachmentTest::new));
    public static final AttachmentType.Builder<ContainerAttachmentTest> BUILDER = AttachmentUtils.createBuilder(ContainerAttachmentTest::new, CODEC, ContainerAttachmentTest::setHolder);
    private final SimpleResourceItemContainer _itemContainer;
    private final RecordFluidContainer _fluidContainer;
    private final RecordEnergyContainer _energyContainer;
    private final RecordEnergyContainer _manaContainer;
    public final transient IResourceContainer<FluidResource> FluidInput;
    public final transient IResourceContainer<FluidResource> FluidOutput;
    public final transient IResourceHandler<FluidResource> FluidInputHandler;
    public final transient IResourceHandler<FluidResource> FluidOutputHandler;
    public final transient IResourceHandler<ItemResource> ItemHandler;
    public final transient IEnergyHandler EnergyHandler;
    public final transient IEnergyHandler ManaHandler;
    private transient BlockEntity _blockEntity;
    private static final int ITEM_COUNT = 1;
    private static final int TANK_COUNT = 4;
    private static final int TANK_CAPACITY = 1000;

    public ContainerAttachmentTest(IAttachmentHolder holder) {
        this(MutableResourceStack.Empty.ITEM.nonNullListOfSize(1), MutableResourceStack.Empty.FLUID.nonNullListOfSize(4), 1000, new int[2], new int[2]);
        this.setHolder(holder);
    }

    public ContainerAttachmentTest(NonNullList<MutableResourceStack<ItemResource>> items, NonNullList<MutableResourceStack<FluidResource>> fluids, int capacity, int[] energyValues, int[] manaValues) {
        this._itemContainer = SimpleResourceItemContainer.from(items, this::runTest);
        this._fluidContainer = RecordFluidContainer.from(fluids, capacity, this::runTest);
        this._energyContainer = RecordEnergyContainer.from(energyValues, 4000, this::runTest);
        this._manaContainer = RecordEnergyContainer.from(manaValues, 4000, this::runTest);
        this.FluidInput = this._fluidContainer.slice(0, 2);
        this.FluidOutput = this._fluidContainer.slice(2, 2);
        this.FluidInputHandler = this.FluidInput.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.FluidOutputHandler = this.FluidOutput.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
        this.EnergyHandler = this._energyContainer.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.ItemHandler = this._itemContainer.asHandler();
        this.ManaHandler = this._manaContainer.asHandler();
        this._manaContainer.slice(0, 1).asHandler(HandlerIOBehavior.INSERT_ONLY).insert(1000, TransferAction.EXECUTE);
        this._manaContainer.slice(1, 1).asHandler(HandlerIOBehavior.EXTRACT_ONLY).insert(1000, TransferAction.EXECUTE);
        this.ManaHandler.insert(1000, TransferAction.EXECUTE);
    }

    private static EnergyContainer getEnergyContainer(ContainerAttachmentTest containerAttachment) {
        return containerAttachment._energyContainer;
    }

    private static EnergyContainer getManaContainer(ContainerAttachmentTest containerAttachment) {
        return containerAttachment._manaContainer;
    }

    public void setHolder(IAttachmentHolder holder) {
        this._blockEntity = (BlockEntity)holder;
    }

    public IResourceContainer<ItemResource> getItemContainer() {
        return this._itemContainer;
    }

    public IResourceContainer<FluidResource> getFluidContainer() {
        return this._fluidContainer;
    }

    public int getTankCapacity() {
        return this._fluidContainer.capacity();
    }

    public void runTest() {
        if (this._blockEntity != null) {
            this._blockEntity.setChanged();
        }
    }
}

