/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class ThrownSpear
extends AbstractArrow
implements ItemSupplier {
    private static final EntityDataAccessor<Boolean> ENCHANTED_ID = SynchedEntityData.defineId(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final ItemStack DEFAULT_STACK = new ItemStack((ItemLike)UGItems.SPEAR.get());
    private boolean dealtDamage;

    public ThrownSpear(EntityType<? extends ThrownSpear> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownSpear(Level level, LivingEntity shooter, ItemStack pickupItemStack) {
        super((EntityType)UGEntityTypes.SPEAR.get(), shooter, level, pickupItemStack, null);
        this.entityData.set(ENCHANTED_ID, (Object)pickupItemStack.hasFoil());
    }

    public ThrownSpear(Level level, double x, double y, double z, ItemStack pickupItemStack) {
        super((EntityType)UGEntityTypes.SPEAR.get(), x, y, z, level, pickupItemStack, pickupItemStack);
        this.entityData.set(ENCHANTED_ID, (Object)pickupItemStack.hasFoil());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ENCHANTED_ID, (Object)false);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        super.tick();
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ENCHANTED_ID);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    protected void onHitEntity(EntityHitResult result) {
        ServerLevel level;
        Entity victim = result.getEntity();
        float damage = 8.0f;
        Entity owner = this.getOwner();
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner));
        Level level2 = this.level();
        if (level2 instanceof ServerLevel) {
            level = (ServerLevel)level2;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)level, (ItemStack)this.getWeaponItem(), (Entity)victim, (DamageSource)damagesource, (float)damage);
        }
        this.dealtDamage = true;
        if (victim.hurt(damagesource, damage)) {
            if (victim.getType() == EntityType.ENDERMAN) {
                return;
            }
            level2 = this.level();
            if (level2 instanceof ServerLevel) {
                level = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)level, (Entity)victim, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
            }
            if (victim instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)victim;
                this.doKnockback(entity, damagesource);
                this.doPostHurtEffects(entity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.0f);
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    public void playerTouch(Player pEntity) {
        if (this.ownedBy((Entity)pEntity) || this.getOwner() == null) {
            super.playerTouch(pEntity);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.dealtDamage = tag.getBoolean("DealtDamage");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("DealtDamage", this.dealtDamage);
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public ItemStack getItem() {
        return DEFAULT_STACK;
    }

    protected ItemStack getDefaultPickupItem() {
        return DEFAULT_STACK;
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }
}

