/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.monster.rotspawn;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.entity.animal.Mog;
import quek.undergarden.entity.monster.denizen.Denizen;
import quek.undergarden.entity.monster.rotspawn.RotspawnMonster;
import quek.undergarden.entity.monster.stoneborn.Stoneborn;
import quek.undergarden.entity.projectile.RotbelcherProjectile;
import quek.undergarden.registry.UGSoundEvents;

public class Rotbelcher
extends RotspawnMonster {
    private static final EntityDataAccessor<Boolean> IS_CHARGING = SynchedEntityData.defineId(Rotbelcher.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public AnimationState shootAnimation = new AnimationState();
    public AnimationState attackAnimation = new AnimationState();

    public Rotbelcher(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RotbelcherShootGoal(this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.25, false){

            public boolean canUse() {
                return this.mob.getTarget() != null && this.mob.getTarget().distanceToSqr((Entity)this.mob) < 40.0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new RotspawnMonster.RotspawnTargetGoal<Player>((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, new RotspawnMonster.RotspawnTargetGoal<Stoneborn>((Mob)this, Stoneborn.class, true));
        this.targetSelector.addGoal(3, new RotspawnMonster.RotspawnTargetGoal<Animal>((Mob)this, Animal.class, true, target -> !(target instanceof Mog)));
        this.targetSelector.addGoal(2, new RotspawnMonster.RotspawnTargetGoal<Denizen>((Mob)this, Denizen.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Rotbelcher.createMobAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.ARMOR, 3.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.23);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.ROTBELCHER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.ROTBELCHER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.ROTBELCHER_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)UGSoundEvents.ROTBELCHER_STEP.get(), 0.15f, 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_CHARGING, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.entityData.set(IS_CHARGING, (Object)charging);
    }

    public boolean doHurtTarget(Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackAnimation.start(this.tickCount);
            this.shootAnimation.stop();
        }
        if (id == 5) {
            this.shootAnimation.start(this.tickCount);
            this.attackAnimation.stop();
        }
    }

    private static class RotbelcherShootGoal
    extends Goal {
        private final Rotbelcher rotbelcher;
        public int chargeTime;

        public RotbelcherShootGoal(Rotbelcher rotbelcher) {
            this.rotbelcher = rotbelcher;
        }

        public boolean canUse() {
            return this.rotbelcher.getTarget() != null && this.rotbelcher.getTarget().distanceToSqr((Entity)this.rotbelcher) > 20.0;
        }

        public void start() {
            this.chargeTime = 0;
        }

        public void stop() {
            this.rotbelcher.setCharging(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity target = this.rotbelcher.getTarget();
            if (target != null) {
                double distanceToTarget = target.distanceToSqr((Entity)this.rotbelcher);
                if (!(distanceToTarget > 40.0)) {
                    this.rotbelcher.getNavigation().stop();
                } else {
                    this.rotbelcher.getNavigation().moveTo((Entity)target, (double)1.2f);
                }
                if (this.rotbelcher.hasLineOfSight((Entity)target)) {
                    Level level = this.rotbelcher.level();
                    ++this.chargeTime;
                    this.rotbelcher.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                    if (this.chargeTime == 40) {
                        level.broadcastEntityEvent((Entity)this.rotbelcher, (byte)5);
                        this.rotbelcher.playSound((SoundEvent)UGSoundEvents.ROTBELCHER_SHOOT.get(), 1.0f, this.rotbelcher.getVoicePitch());
                        Vec3 vec3 = this.rotbelcher.getViewVector(1.0f);
                        double x = target.getX() - (this.rotbelcher.getX() + vec3.x);
                        double y = target.getY(0.5) - (0.5 + this.rotbelcher.getY(0.5));
                        double z = target.getZ() - (this.rotbelcher.getZ() + vec3.z);
                        Vec3 shootVector = new Vec3(x, y, z);
                        RotbelcherProjectile projectile = new RotbelcherProjectile(level, (LivingEntity)this.rotbelcher, shootVector.normalize());
                        projectile.setPos(this.rotbelcher.getX() + vec3.x, this.rotbelcher.getY(0.5) + 0.5, projectile.getZ() + vec3.z);
                        level.addFreshEntity((Entity)projectile);
                        this.chargeTime = -8;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.rotbelcher.setCharging(this.chargeTime > 10);
            }
        }
    }
}

