/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.monster.denizen;

import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.entity.monster.denizen.DenizenChillByCampfireGoal;
import quek.undergarden.entity.monster.denizen.DenizenSpearAttackGoal;
import quek.undergarden.entity.monster.denizen.DenizenStareAtPlayerGoal;
import quek.undergarden.entity.monster.denizen.DenizenStareDownTargetGoal;
import quek.undergarden.entity.monster.denizen.DenizenWanderGoal;
import quek.undergarden.entity.monster.rotspawn.RotspawnMonster;
import quek.undergarden.entity.projectile.ThrownSpear;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGPointOfInterests;

public class Denizen
extends Monster
implements VariantHolder<Type>,
RangedAttackMob {
    private static final EntityDataAccessor<Integer> TYPE_ID = SynchedEntityData.defineId(Denizen.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDimensions SHORT = EntityDimensions.scalable((float)0.85f, (float)1.9f).withEyeHeight(1.75f);
    private static final EntityDimensions SHORT_SITTING = EntityDimensions.scalable((float)0.85f, (float)1.4f).withEyeHeight(1.2f);
    private static final EntityDimensions TALL = EntityDimensions.scalable((float)0.85f, (float)3.3f).withEyeHeight(3.0f);
    private static final EntityDimensions TALL_SITTING = EntityDimensions.scalable((float)0.85f, (float)1.8f).withEyeHeight(1.4f);
    @Nullable
    private LivingEntity stareTarget;
    @Nullable
    private BlockPos satAtCampfire;

    public Denizen(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new DenizenStareAtPlayerGoal(this));
        this.goalSelector.addGoal(2, (Goal)new DenizenSpearAttackGoal(this, 1.0, 40, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(3, (Goal)new DenizenWanderGoal(this, 0.6));
        this.goalSelector.addGoal(4, (Goal)new DenizenChillByCampfireGoal(this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Denizen.class, 8.0f){

            public boolean canUse() {
                return Denizen.this.getStareTarget() == null && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new DenizenStareDownTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, RotspawnMonster.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    public Vec3 getVehicleAttachmentPoint(Entity entity) {
        return new Vec3(0.0, -0.5, 0.0);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return switch (this.getVariant().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.hasPose(Pose.SITTING)) {
                    yield SHORT_SITTING;
                }
                yield SHORT;
            }
            case 1 -> this.hasPose(Pose.SITTING) ? TALL_SITTING : TALL;
        };
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("Type", this.getVariant().getSerializedName());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(Type.byName(tag.getString("Type")));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE_ID, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        if (TYPE_ID.equals(accessor)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(accessor);
    }

    public void setVariant(Type variant) {
        this.getEntityData().set(TYPE_ID, (Object)variant.getId());
    }

    public Type getVariant() {
        return Type.byId((Integer)this.entityData.get(TYPE_ID));
    }

    @Nullable
    public LivingEntity getStareTarget() {
        return this.stareTarget;
    }

    public void setStareTarget(@Nullable LivingEntity target) {
        this.stareTarget = target;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        if (random.nextBoolean()) {
            if (random.nextBoolean()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)UGItems.SPEAR.get()));
            } else if (random.nextBoolean()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_AXE));
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean flag = super.hurt(source, amount);
        if (flag && this.hasPose(Pose.SITTING)) {
            this.setPose(Pose.STANDING);
        }
        return flag;
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        if (this.level() instanceof ServerLevel) {
            this.resetCampfireLogic();
        }
    }

    @Nullable
    public BlockPos getCampfire() {
        return this.satAtCampfire;
    }

    public void setCampfire(@Nullable BlockPos pos) {
        this.satAtCampfire = pos;
    }

    public void resetCampfireLogic() {
        Optional maybeCampfire;
        if (this.satAtCampfire != null && (maybeCampfire = ((ServerLevel)this.level()).getPoiManager().getType(this.satAtCampfire)).isPresent() && ((Holder)maybeCampfire.get()).is(UGPointOfInterests.DENIZEN_RESTING_BLOCKS.getKey())) {
            ((ServerLevel)this.level()).getPoiManager().release(this.satAtCampfire);
        }
        this.setPose(Pose.STANDING);
        this.satAtCampfire = null;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(level, difficulty, reason, data);
        if (level.getRandom().nextBoolean()) {
            this.setVariant(Type.TALL);
        } else {
            this.setVariant(Type.SHORT);
        }
        this.populateDefaultEquipmentSlots(level.getRandom(), difficulty);
        return data;
    }

    public void performRangedAttack(LivingEntity pTarget, float pVelocity) {
        ThrownSpear spear = new ThrownSpear(this.level(), (LivingEntity)this, new ItemStack((ItemLike)UGItems.SPEAR.get()));
        double x = pTarget.getX() - this.getX();
        double y = pTarget.getY(0.3333333333333333) - spear.getY();
        double z = pTarget.getZ() - this.getZ();
        double d3 = Math.sqrt(x * x + z * z);
        spear.shoot(x, y + d3 * (double)0.2f, z, 1.6f, 14 - this.level().getDifficulty().getId() * 4);
        this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)spear);
    }

    public static enum Type implements StringRepresentable
    {
        SHORT(0, "short"),
        TALL(1, "tall");

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final int id;
        private final String name;

        private Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String name) {
            return (Type)CODEC.byName(name, (Enum)SHORT);
        }

        public static Type byId(int index) {
            return BY_ID.apply(index);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

