/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import quek.undergarden.client.model.RotbelcherModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.layer.RotbelcherEyesLayer;
import quek.undergarden.entity.monster.rotspawn.Rotbelcher;

public class RotbelcherRenderer
extends MobRenderer<Rotbelcher, RotbelcherModel<Rotbelcher>> {
    private static final ResourceLocation ROTBELCHER = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"textures/entity/rotbelcher.png");

    public RotbelcherRenderer(EntityRendererProvider.Context context) {
        super(context, new RotbelcherModel(context.bakeLayer(UGModelLayers.ROTBELCHER)), 0.6f);
        this.addLayer((RenderLayer)new RotbelcherEyesLayer(this));
    }

    public ResourceLocation getTextureLocation(Rotbelcher entity) {
        return ROTBELCHER;
    }

    public void setupRotations(Rotbelcher entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entity, stack, ageInTicks, rotationYaw, partialTicks, scale);
        if (!((double)entity.walkAnimation.speed() < 0.01)) {
            float f1 = entity.walkAnimation.position() - entity.walkAnimation.speed() * (1.0f - partialTicks) + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            stack.mulPose(Axis.ZP.rotationDegrees(6.5f * f2));
        }
    }
}

