/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGParticleTypes;

public class UGDripParticles
extends DripParticle {
    public UGDripParticles(ClientLevel level, double x, double y, double z, Fluid fluid) {
        super(level, x, y, z, fluid);
    }

    public static TextureSheetParticle createBloodHangParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.DripHangParticle hangParticle = new DripParticle.DripHangParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)UGParticleTypes.FALLING_BLOOD.get());
        hangParticle.gravity *= 0.01f;
        hangParticle.setLifetime(10);
        hangParticle.setColor(0.622f, 0.082f, 0.082f);
        return hangParticle;
    }

    public static TextureSheetParticle createBloodFallParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.FallAndLandParticle dripparticle = new DripParticle.FallAndLandParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)UGParticleTypes.LANDING_BLOOD.get());
        dripparticle.gravity = 0.01f;
        dripparticle.setColor(0.622f, 0.082f, 0.082f);
        return dripparticle;
    }

    public static TextureSheetParticle createBloodLandParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.DripLandParticle dripparticle = new DripParticle.DripLandParticle(level, x, y, z, Fluids.EMPTY);
        dripparticle.setLifetime((int)(64.0 / (Math.random() * 0.8 + 0.2)));
        dripparticle.setColor(0.622f, 0.082f, 0.082f);
        return dripparticle;
    }

    public static TextureSheetParticle createInkHangParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.DripHangParticle hangParticle = new DripParticle.DripHangParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)UGParticleTypes.FALLING_INK.get());
        hangParticle.gravity *= 0.01f;
        hangParticle.setLifetime(10);
        hangParticle.setColor(0.0f, 0.0f, 0.0f);
        return hangParticle;
    }

    public static TextureSheetParticle createInkFallParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.FallAndLandParticle dripparticle = new DripParticle.FallAndLandParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)UGParticleTypes.LANDING_INK.get());
        dripparticle.gravity = 0.01f;
        dripparticle.setColor(0.0f, 0.0f, 0.0f);
        return dripparticle;
    }

    public static TextureSheetParticle createInkLandParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.DripLandParticle dripparticle = new DripParticle.DripLandParticle(level, x, y, z, Fluids.EMPTY);
        dripparticle.setLifetime((int)(64.0 / (Math.random() * 0.8 + 0.2)));
        dripparticle.setColor(0.0f, 0.0f, 0.0f);
        return dripparticle;
    }

    public static TextureSheetParticle createGooFallParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.FallAndLandParticle dripparticle = new DripParticle.FallAndLandParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)UGParticleTypes.LANDING_GOO.get());
        dripparticle.gravity = 0.01f;
        dripparticle.setColor(0.482f, 0.447f, 0.329f);
        return dripparticle;
    }

    public static TextureSheetParticle createGooLandParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.DripLandParticle dripparticle = new DripParticle.DripLandParticle(level, x, y, z, Fluids.EMPTY);
        dripparticle.setLifetime((int)(32.0 / (Math.random() * 0.8 + 0.2)));
        dripparticle.setColor(0.482f, 0.447f, 0.329f);
        return dripparticle;
    }

    public static TextureSheetParticle createDripstoneVirulentHangParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.DripHangParticle dripparticle = new DripParticle.DripHangParticle(level, x, y, z, (Fluid)UGFluids.VIRULENT_MIX_SOURCE.get(), (ParticleOptions)UGParticleTypes.FALLING_VIRULENT.get());
        dripparticle.setColor(0.3f, 0.0f, 0.3f);
        return dripparticle;
    }

    public static TextureSheetParticle createDripstoneVirulentFallParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        VirulentFallAndLandParticle dripparticle = new VirulentFallAndLandParticle(level, x, y, z, (Fluid)UGFluids.VIRULENT_MIX_SOURCE.get(), (ParticleOptions)UGParticleTypes.LANDING_VIRULENT.get());
        dripparticle.setColor(0.3f, 0.0f, 0.3f);
        return dripparticle;
    }

    public static TextureSheetParticle createVirulentLandParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        DripParticle.DripLandParticle dripparticle = new DripParticle.DripLandParticle(level, x, y, z, (Fluid)UGFluids.VIRULENT_MIX_SOURCE.get());
        dripparticle.setColor(0.3f, 0.0f, 0.3f);
        return dripparticle;
    }

    static class VirulentFallAndLandParticle
    extends DripParticle.FallAndLandParticle {
        public VirulentFallAndLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions particle) {
            super(level, x, y, z, fluid, particle);
        }

        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.landParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                float f = Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)1.0f);
                this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA, SoundSource.BLOCKS, f, 1.0f, false);
            }
        }
    }
}

